/***************************************************************************
 *   Copyright (C) 2008-2009 by fra74                                           *
 *   francesco.b74@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef SCHEDATRENO_H
#define SCHEDATRENO_H

#include "schedaviaggiatreno.h"

namespace Treno
{
enum Dati {dtPartenza, dtOrarioPartenzaProgrammato, dtOrarioPartenzaReale, dtBinarioPartenzaProgrammato, dtBinarioPartenzaReale,
		   dtArrivo, dtOrarioArrivoProgrammato, dtOrarioArrivo, dtBinarioArrivoProgrammato, dtBinarioArrivoReale,
		   dtOrarioTransito, dtRitardoTransito, dtUltimoRilevamento, dtProvvedimenti };

enum {colFermata = 0, colEffettuata, colBinarioProgrammato, colBinarioReale,
	  colArrivoProgrammato, colArrivoStimato, colArrivoReale, colUltima=colArrivoReale};

class Fermata
{
public:
	Fermata();

	QString nomeFermata() const {return m_fermata;}
	QString binarioProgrammato() const {return m_binProgrammato;}
	QString binarioReale() const {return m_binReale;}
	QString oraArrivoProgrammata() const {return m_oraArrivoProgrammata;}
	QString oraArrivoStimata() const {return m_oraArrivoStimata;}
	QString oraArrivoReale() const {return m_oraArrivoReale;}
	bool effettuata() const {return m_effettuata;}
	bool soppressa() const {return m_soppressa;}

	void impostaNomeFermata(const QString& fermata) {m_fermata = fermata;}
	void impostaBinarioProgrammato(const QString& binarioProgrammato) {m_binProgrammato = binarioProgrammato;}
	void impostaBinarioReale(const QString& binarioReale) {m_binReale = binarioReale;}
	void impostaOraArrivoProgrammata(const QString& oraArrivoProgrammata) {m_oraArrivoProgrammata = oraArrivoProgrammata;}
	void impostaOraArrivoStimata(const QString& oraArrivoStimata) {m_oraArrivoStimata = oraArrivoStimata;}
	void impostaOraArrivoReale(const QString& oraArrivoReale) {m_oraArrivoReale = oraArrivoReale;}
	void impostaEffetuata(bool eff) {m_effettuata = eff;}
	void impostaSoppressa(bool sopp) {m_soppressa = sopp; m_effettuata = false;}

private:
	QString m_fermata;
	QString m_binProgrammato, m_binReale;
	QString m_oraArrivoProgrammata, m_oraArrivoStimata, m_oraArrivoReale;
	bool m_effettuata, m_soppressa;

};

class DatiTreno
{
	public:
	DatiTreno() {m_statoTreno = DatiSconosciuti;}

	void impostaStatoTreno(StatoTreno stato) {m_statoTreno = stato;}
	StatoTreno statoTreno() const {return m_statoTreno;}

	void inizializza();

	QString numeroTreno() const {return m_numero; }
	void impostaNumeroTreno(const QString& numero) {m_numero = numero; }

	void impostaDato(Dati tipoDato, const QString& valore) {m_dati[tipoDato] = valore; }
	QString dato(Dati tipoDato) const {return m_dati[tipoDato]; }

	QList<Fermata*> fermate() const {return m_fermate;}
	void aggiungiFermata(Fermata* f) {m_fermate.append(f);}

	private:
	StatoTreno m_statoTreno;
	QString m_numero;
	QMap<int, QString> m_dati;
	QList<Fermata*> m_fermate;

};
};

class QViaggiaTreno;
class WidgetDatiTreno;
class ModelloFermateTreno;

class SchedaTreno : public SchedaViaggiaTreno
{
	Q_OBJECT

public:
	SchedaTreno(QViaggiaTreno *parent, const QString & numero, const unsigned int intervalloStandard = 2);

	QString numero() const;
	virtual QString titolo( bool titoloItem = false) const;

	virtual void salvaScheda(QSettings& );

public slots:
	virtual void aggiorna();

protected slots:
	virtual void downloadFinito(QNetworkReply  *risposta);

private:
	void analizzaRiepilogo(const QString& testoVT);
	void analizzaDettagli(const QString& testoVT);

private:
	QString m_numero;
	int m_idTabelle, m_idNumeroSbagliato;
	bool m_riepilogoScaricato;
	Treno::DatiTreno m_orarioTreno;
	WidgetDatiTreno* m_widget;
};

class TabellaFermate;
class WidgetDatiTreno : public QWidget
{
	Q_OBJECT

public:
	WidgetDatiTreno(SchedaTreno* parent);

	void impostaNumeroTreno(const QString& numero);
	void impostaAggiornamento(const QString& orario);
	void aggiornaTreno(const Treno::DatiTreno& treno);
	void impostaStato(StatoTreno stato);
	void impostaStato(StatoTreno stato, Treno::DatiTreno treno);
	void impostaProvvedimenti(const QString& provvedimenti);

	void inizializza();

private:
	QLabel *m_titolo, *m_aggiornamento;
	QLabel *m_stazionePartenza, *m_partenzaTeorica, *m_binPartenzaProgrammato, *m_partenzaReale, *m_binPartenzaReale;
	QLabel *m_stazioneArrivo, *m_arrivoProgrammato, *m_binArrivoProgrammato, *m_arrivo, *m_binArrivoReale;
	QLabel *m_stato, *m_provvedimenti;
	TabellaFermate * m_tabella;

private slots:
	void linkAttivato(const QString& testo);
	void itemAttivato(QTableWidgetItem* item);

signals:
	void apriSchedaStazione(const QString&);
};

class TabellaFermate : public QTableWidget
{
Q_OBJECT

public:
	TabellaFermate(QWidget* parent);

	void ridimensionaColonne();

protected:
	virtual void mouseMoveEvent(QMouseEvent *event);
};


#endif // SCHEDATRENO_H
