$LOAD_PATH << '..' unless $LOAD_PATH.include? '..'
require 'qwik/site-plan'

module Qwik
  class Action
    D_PluginPlan = {
      :dt => 'Show plan plugin',
      :dd => 'You can show the plan of this group.',
      :dc => "* Example
 {{plan}}
{{plan}}
You can see plans of this group.
If there are no plan for this group, you see nothing.
* How to create new plan.
Follow '''Create a new plan''' link and create a new plan page.
You'll see plans on sidemenu.
'''Notice''' We changed the format of the date of pages.
You can not use tag notation to specify date now.
"
    }

    D_PluginPlan_ja = {
      :dt => '\\vOC',
      :dd => '\\܂B',
      :dc => "* 
 {{plan}}
{{plan}}
\肪o^Ăꍇ́ÃvOCŕ\܂B
* \̓o^@
ԉ́uV\o^vƂNǂāA
V\y[WĂB
TChj[ɗ\肪\悤ɂȂ܂B
ߋ̗\͕\܂B܂Nȏ̗\\܂B
ꃖx̗\o^Ă݂ĂB

'''''' ȑO̓^OL@ɂtw̗pĂ܂A
Vo[WL̐VK\y[Wɐ؂ւ܂B
䗹B
"
    }

    def plg_side_plan
      div = [:div, [:h2, _('Plan')]]
      pages = @site.get_pages_with_date
      div << plan_make_html(pages) if ! pages.empty?
      div << [:p, plg_new_plan]
      return div
    end

    def plg_plan
      div = [:div, [:h2, _('Plan')]]
      pages = @site.get_pages_with_date
      return if pages.empty?
      div << plan_make_html(pages)
      div << [:p, plg_new_plan]
      return div
    end

    def plg_new_plan
      return [:a, {:href=>'.plan'}, _('Create a new plan')]
    end

    def plan_make_html(pages)
      day = 60 * 60 * 24
      nowi = @req.start_time.to_i
      pages = pages.select {|pagekey, datei|
	page = @site[pagekey]
	diff = datei - nowi
	-day < diff
      }
      return nil if pages.empty?

      ul = [:ul]
      pages.sort_by {|pagekey, datei|
	datei
      }.each {|pagekey, datei|
	page = @site[pagekey]
	title = page.get_title
	date = Time.at(datei)
	now = Time.at(nowi)
	date_abbr = Time.date_abbr(now, date)
	em_title = Time.date_emphasis(now, date, title)
	ul << [:li, "#{date_abbr} ", [:a, {:href=>"#{pagekey}.html"}, em_title]]
      }
      return ul
    end

    # Make a new plan.
    def act_plan
      date = @req.query['date']
      title = @req.query['title']
      if date.nil? || date.empty? || title.nil? || title.empty?
	date_attr = {:name=>'date', :class => 'focus'}
	date_attr[:value] = date if date && ! date.empty?
	title_attr = {:name=>'title'}
	title_attr[:value] = title if title && ! title.empty?
	form = [:form, {:action=>'.plan', :method=>'POST'},
	  [:dl,
	    [:dt, _('Date')],
	    [:dd, [:input, date_attr]],
	    [:dt, _('Title')],
	    [:dd, [:input, title_attr]]],
	  [:input, {:type=>'submit', :value=>_('Create a new plan')}]]
	return c_notice(_('New plan')) {
	  [[:h2, _('New plan')],
	    [:div, {:class=>'plan form'},
	      form]]
	}
      end

      # Create a new plan
      #page = @site.create_new	# CREATE

      dateobj = Time.parse(date)
      
      pagename = "plan_#{dateobj.ymd_s}"
      page = @site[pagename]
      page = @site.create(pagename) if page.nil?	# CREATE
      page.store("* #{title}\n")	# Specify title.

      url = "#{page.key}.edit"
      return c_notice(_('New plan'), url, 201) {	# 201, Created
	[[:h2, _('Created.')],
	  [:p, [:a, {:href=>url}, _('Edit new page')]]]
      }
    end
  end
end

if $0 == __FILE__
  require 'qwik/test-common'
  $test = true
end

if defined?($test) && $test
  class TestActPlan < Test::Unit::TestCase
    include TestSession

    def create_plan_pages(site)
      page = site.create 'plan_19700101'
      page.store("* t")
      page = site.create 'plan_19700115'
      page.store("* t")
      page = site.create 'plan_19700201'
      page.store("* t")
      page = site.create 'plan_19710101'
      page.store("* t")
    end

    def test_plg_plan
      ok_wi([], '{{plan}}')

      create_plan_pages(@site)

      ok_wi [:div,
	[:h2, "Plan"],
	[:ul,
	  [:li, "01-01 ", [:a, {:href=>"plan_19700101.html"}, [:strong, "t"]]],
	  [:li, "01-15 ", [:a, {:href=>"plan_19700115.html"}, [:em, "t"]]],
	  [:li, "02-01 ", [:a, {:href=>"plan_19700201.html"},
	      [:span, {:class=>"future"}, "t"]]],
	  [:li, "1971-01-01 ", [:a, {:href=>"plan_19710101.html"},
	      [:span, {:class=>"future"}, "t"]]]],
	[:p, [:a, {:href=>".plan"}, "Create a new plan"]]],
	'{{plan}}'

      # $KCODE = 'n'
      eq "\227\\\222\350", '\'
    end

    def ok_date(num, date)
      assert_equal(num, Time.parse(date).to_i + Time::now.utc_offset)
    end

    def test_parsedate
      ok_date 0, '1970-01-01'
      ok_date 0, '19700101'
      ok_date 0, '1970/01/01'
      ok_date 0, '1970/1/1'
    end

    def test_plan
      t_add_user

      ok_wi [:div, [:h2, "Plan"], [:p, [:a, {:href=>".plan"},
	    "Create a new plan"]]], '{{side_plan}}'

      # Go create a new plan page.
      res = session '/test/.plan'
      ok_in ["New plan"], '//h1'
      ok_attr({:action=>".plan", :method=>"POST"}, '//form')
      ok_attr({:class=>"focus", :name=>"date"}, '//input')
      ok_attr({:name=>"title"}, '//input[2]')

      page = @site.create_new
      page.store('t1')

    end

  end
end
