#
# Copyright (C) 2003-2006 Kouichirou Eto
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

$LOAD_PATH << '..' unless $LOAD_PATH.include? '..'
require 'qwik/ml-session'
require 'qwik/test-module-ml'

if $0 == __FILE__
  $test = true
end

class TestMSQuotedPrintable < Test::Unit::TestCase
  include TestModuleML

  def test_all
    send_normal_mail('bob@example.net')
    ok_log(['[test]: New ML by bob@example.net',
	     '[test]: Add: bob@example.net',
	     '[test]: QwikPost: test'], 0..2)

    sendmail('[qwik-users:217] Gmail=?iso-2022-jp?B?GyRCJCwbKEJKSVMbJEIlKCVzJTMhPCVHJSMbKEI=?= 
 =?iso-2022-jp?B?GyRCJXMlMCRLO0VNTUpROTkbKEI=?=',
       'user@gmail.com', 'test@example.com') {
'Content-Type: text/plain; charset=ISO-2022-JP
Content-Transfer-Encoding: quoted-printable

=1B$B$3$s$K$A$O!#=1B(B

--=20
user
' }

#    ok_eq('quoted-printable', mail['Content-Transfer-Encoding'])
#    ok_eq('GmailJISGR[fBOɎdlύX',
#		 mail.get_clean_subject)
#    ok_eq("ɂ́B\n\n-- \nuser\n".set_sourcecode_charset.to_mail_charset, mail.decoded_body)
=begin
    page = @site['1']
    ok_eq('GmailJISGR[fBOɎdlύX', page.get_title)
    ok_eq("* GmailJISGR[fBOɎdlύX\n{{mail(user@gmail.com,0)\nɂ́B\n\n-- \nuser\n}}\n", page.load)

    page = @site['1']
    ok_eq('eXg', page.get_title)
    ok_eq("* eXg\n{{mail(bob@example.net,0)\n}}\n", page.get)
#    ok_eq(true, @site.files('1').exist?('1x1.png'))
=end
  end

  def nutest_all
    qml = QuickML::Group.new(@ml_config, 'test@example.com')
    qml.setup_test_config
    mail = post_mail(qml) {
'Date: Mon, 3 Feb 2001 12:34:56 +0900
From: user@gmail.com
To: test@example.com
Subject: [qwik-users:217] Gmail=?iso-2022-jp?B?GyRCJCwbKEJKSVMbJEIlKCVzJTMhPCVHJSMbKEI=?= 
 =?iso-2022-jp?B?GyRCJXMlMCRLO0VNTUpROTkbKEI=?=
Content-Type: text/plain; charset=ISO-2022-JP
Content-Transfer-Encoding: quoted-printable

=1B$B$3$s$K$A$O!#=1B(B

--=20
user
' }
    ok_eq('quoted-printable', mail['Content-Transfer-Encoding'])
    ok_eq('[qwik-users:217] GmailJISGR[fBOɎdlύX'.set_sourcecode_charset.to_mail_charset, mail['Subject'])
    ok_eq('GmailJISGR[fBOɎdlύX',
	  mail.get_clean_subject)
    ok_eq("ɂ́B\n\n-- \nuser\n".set_sourcecode_charset.to_mail_charset, mail.decoded_body)
    page = @site['1']
    ok_eq('GmailJISGR[fBOɎdlύX', page.get_title)
    ok_eq("* GmailJISGR[fBOɎdlύX\n{{mail(user@gmail.com,0)\nɂ́B\n\n-- \nuser\n}}\n", page.load)
  end
end
