% File src/library/methods/man/SClassExtension-class.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Development Team
% Distributed under GPL 2 or later

\name{SClassExtension-class}
\docType{class}
\alias{SClassExtension-class}
\title{Class to Represent Inheritance (Extension) Relations }
\description{  An object from this class represents a single \sQuote{is}
  relationship; lists of these objects are used to represent all the
  extensions (superclasses) and subclasses for a given class.  The
  object contains information about how the relation is defined and
  methods to coerce, test, and replace correspondingly. }
\section{Objects from the Class}{
  Objects from this class are generated by \code{\link{setIs}},
  from direct calls and from the \code{contains=} information in a call to \code{\link{setClass}}, and from class unions created by \code{\link{setClassUnion}}.
  In the last case, the information is stored in defining the \emph{subclasses} of the union class (allowing unions to contain sealed classes).
}
\section{Slots}{
  \describe{
    \item{\code{subClass,superClass}:}{The classes being extended:
    corresponding to the \code{from}, and \code{to} arguments to \code{\link{setIs}}. }
    \item{\code{package}:}{The package to which that class belongs. }
    \item{\code{coerce}:}{A function to carry out the as() computation
    implied by the relation.  Note that these functions should
    \emph{not} be used directly.  They only deal with the
    \code{strict=TRUE} calls to the \code{\link{as}} function, with
    the full method constructed from this mechanically. }
    \item{\code{test}:}{The function that would test whether the
    relation holds.  Except for explicitly specified \code{test}
    arguments to \code{\link{setIs}}, this function is trivial. }
    \item{\code{replace}:}{The method used to implement \code{as(x,
    Class) <- value}.}
    \item{\code{simple}:}{A \code{"logical"} flag, \code{TRUE} if this
    is a simple relation, either because one class is contained in the
    definition of another, or because a class has been explicitly
    stated to extend a virtual class.  For simple extensions, the
    three methods are generated automatically.}
    \item{\code{by}:}{If this relation has been constructed
    transitively, the first intermediate class from the subclass. }
    \item{\code{dataPart}:}{A \code{"logical"} flag, \code{TRUE} if
  the extended class is in fact the data part of the subclass.  In
  this case the extended class is a basic class (i.e., a type). }
    \item{\code{distance}:}{The distance between the two classes,
    1 for directly contained classes, plus the number of generations between otherwise. }  }
}

\section{Methods}{
  No methods defined with class \code{"SClassExtension"} in the
  signature.
}
\seealso{
  \code{\link{is}},
  \code{\link{as}}, and the
  \code{\linkS4class{classRepresentation}} class.
}
\keyword{classes}
