#  File src/library/utils/R/zzz.R
#  Part of the R package, http://www.R-project.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  http://www.r-project.org/Licenses/

.noGenerics <- TRUE

.onLoad <- function(libname, pkgname)
{
    ## Set default options() related to functionality in 'utils' pkg
    op <- options()
    op.utils <-
	list(help.try.all.packages = FALSE,
	     internet.info = 2,
	     pkgType = .Platform$pkgType,
	     str = list(strict.width = "no", digits.d = 3, vec.len = 4),
	     demo.ask = "default", example.ask = "default",
	     HTTPUserAgent = defaultUserAgent(),
	     menu.graphics = TRUE)
    extra <-
        if(.Platform$OS.type == "windows") {
            list(mailer = "none",
                 unzip = "internal",
                 editor = if(length(grep("Rgui", commandArgs(), TRUE))) "internal" else "notepad",
                 repos = c(CRAN="@CRAN@",
                 CRANextra="http://www.stats.ox.ac.uk/pub/RWin")
                 )
        } else
            list(mailer = "mailx",
                 unzip = as.vector(Sys.getenv("R_UNZIPCMD")),
                 editor = as.vector(Sys.getenv("EDITOR")),
                 repos = c(CRAN="@CRAN@"))
    op.utils <- c(op.utils, extra)
    toset <- !(names(op.utils) %in% names(op))
    if(any(toset)) options(op.utils[toset])
}
