% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocCheck-class.R
\name{BiocCheck-methods}
\alias{BiocCheck-methods}
\alias{add,BiocCheck-method}
\title{A list of methods for the BiocCheck reference class}
\arguments{
\item{...}{character() A vector that makes up the \code{BiocCheck} exception
message (e.g., 'Vignette must be built by R CMD build'). The character
vector is handled with \code{paste0} and made into a list and appended with
\code{help_text} and \code{messages}.}

\item{help_text}{character(1) Additional text prompting a list of files
(e.g,. "Found in files:")}

\item{condition}{character(1) One of the three conditions handled: \code{error},
\code{warning}, or \code{note}}

\item{messages}{character() Often a vector of file names where the check
was triggered.}

\item{verbose}{logical(1) Whether or not to output both the \code{help_text} and
\code{messages} as part of the report}

\item{debug}{logical(1) Whether to append the name of the originating check
name into for traceability}

\item{checkName}{character(1) The title of the current group of checks. It
can be set with \code{handleCheck}, e.g., \code{handleCheck("Checking for version number mismatch...")}. Internally, it is saved with \code{setCheck} and obtained
with \code{getLastCheck}.}

\item{isOnBBS}{logical(1) Indicates whether the checks are being run on the
Bioconductor Build System (BBS). This is helpful for avoiding the creation
of folders in the BBS.}

\item{file}{character(1) A path to a JSON file for writing or reading as
created by \code{toJSON} and \code{fromJSON} \code{BiocCheck} methods.}
}
\description{
A list of methods for the BiocCheck reference class
}
\section{methods}{

\describe{
\item{add}{ Include a condition to the \code{BiocCheck} report }
\item{getLastCheck}{ Obtain the name of the last check run }
\item{setCheck}{ Create a new element in the internal list for a check }
\item{get}{ Extract the list of conditions raised by \code{BiocCheck} }
\item{getNum}{ Tally the number of condition provided by the input }
\item{zero}{ Reset the internal log of the condition provided }
\item{getBiocCheckDir}{ Report and create the \verb{<package>.BiocCheck}
directory as obtained from the metadata }
\item{composeReport}{ Simplify the list structure from the \code{log} and
provide a character vector of conditions raised }
\item{report}{ Write the \verb{00BiocCheck.log} report into the \code{BiocCheck}
folder }
\item{toJSON}{ Write a JSON file to the location indicated with the
conditions raised }
\item{fromJSON}{ Read a JSON file from the location indicated with the
output of previous conditions raised in the check }
\item{show}{ Display the information in the class. Currently empty. }
\item{show_meta}{ Display the metadata information stored in the \code{metadata}
field }
}
}

