% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colLogSumExps.R, R/rowLogSumExps.R
\name{colLogSumExps,DelayedMatrix-method}
\alias{colLogSumExps,DelayedMatrix-method}
\alias{rowLogSumExps,DelayedMatrix-method}
\title{Accurately calculates the logarithm of the sum of exponentials for each row
(column) of a matrix-like object}
\usage{
\S4method{colLogSumExps}{DelayedMatrix}(
  lx,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowLogSumExps}{DelayedMatrix}(
  lx,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)
}
\arguments{
\item{lx}{A NxK \linkS4class{DelayedMatrix}. Typically, \code{lx} are \eqn{log(x)} values.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset (and/or
columns) to operate over. If \code{\link{NULL}}, no subsetting is done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Accurately calculates the logarithm of the sum of exponentials for each row
(column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowLogSumExps}} /
\code{matrixStats::\link[matrixStats]{colLogSumExps}}.
}
\examples{
x <- DelayedArray(matrix(runif(10), ncol = 2))
colLogSumExps(log(x))
rowLogSumExps(log(x))
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowLogSumExps}()} and
\code{matrixStats::\link[matrixStats:rowLogSumExps]{colLogSumExps}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item \code{\link[MatrixGenerics:rowSums2]{rowSums2()}}
}
}
\author{
Peter Hickey
}
