% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_which.r
\name{l_which}
\alias{l_which}
\title{Logical which}
\usage{
l_which(idx, nms = seq_len(len), len = length(nms), useNames = TRUE)
}
\arguments{
\item{idx}{Numeric or character indices.}

\item{nms}{Array of names or a sequence. Required if \code{idx} is a character array}

\item{len}{Length of output array. Alternative to \code{nms} if \code{idx} is numeric}

\item{useNames}{Use the names of nms or idx}
}
\value{
Logical vector of length \code{len} or the same length as \code{nms}
}
\description{
Inverse of \link[base]{which}. Converts an array of numeric or character indices to a logical index array.
This function is useful if you need to perform logical operation on an index array but are only given numeric indices.
}
\details{
Either \code{nms} or \code{len} has to be specified.
}
\examples{
all(l_which(2, len = 3L) == c(FALSE, TRUE, FALSE))
all(l_which(c('a', 'c'), letters[1:3]) == c(TRUE, FALSE, TRUE))

}
