% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationTest.R
\name{correctIndices}
\alias{correctIndices}
\title{Calculate the correct indices for the output of correlationTest}
\usage{
correctIndices(n)
}
\arguments{
\item{n}{The number of features compared by correlationTest (nrow(mat)).}
}
\value{
A vector of the indices for an upper triangular matrix.
}
\description{
Consider the upper triangular portion of a matrix of size nxn. Results from the \code{correlationTest} are output
as the combination of two vectors, correlation statistic and p-values. The order of the output is 1vs2, 1vs3, 1vs4, etc.
The correctIndices returns the correct indices to fill a correlation matrix or correlation-pvalue matrix.
}
\examples{

data(mouseData)
mat = MRcounts(mouseData)[55:60,]
cors = correlationTest(mat)
ind  = correctIndices(nrow(mat))

cormat = as.matrix(dist(mat))
cormat[cormat>0] = 0
cormat[upper.tri(cormat)][ind] = cors[,1]
table(cormat[1,-1] - cors[1:5,1])

}
\seealso{
\code{\link{correlationTest}}
}

