% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitTimeSeries.R
\name{ssFit}
\alias{ssFit}
\title{smoothing-splines anova fit}
\usage{
ssFit(formula, abundance, class, time, id, include = c("class", "time:class"),
  pd, ...)
}
\arguments{
\item{formula}{Formula for ssanova. Of the form: abundance ~ ... where ... includes any pData slot value.}

\item{abundance}{Numeric vector of abundances.}

\item{class}{Class membership (factor of group membership).}

\item{time}{Time point vector of relative times (same length as abundance).}

\item{id}{Sample / patient id.}

\item{include}{Parameters to include in prediction.}

\item{pd}{Extra variable.}

\item{...}{Extra parameters for ssanova function (see ?ssanova).}
}
\value{
\itemize{A list containing:
\item     data        : Inputed data
\item     fit         : The interpolated / fitted values for timePoints
\item     se          : The standard error for CI intervals
\item     timePoints  : The time points interpolated over
}
}
\description{
Sets up a data-frame with the feature abundance, 
class information, time points, sample ids and returns
the fitted values for the fitted model.
}
\examples{

# Not run

}
\seealso{
\code{\link{cumNorm}} \code{\link{fitTimeSeries}} \code{\link{ssPermAnalysis}} \code{\link{ssPerm}} \code{\link{ssIntervalCandidate}}
}

