% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateMappingBiasVcf.R
\name{calculateMappingBiasGatk4}
\alias{calculateMappingBiasGatk4}
\title{Calculate Mapping Bias from GATK4 GenomicsDB}
\usage{
calculateMappingBiasGatk4(
  workspace,
  reference.genome,
  min.normals = 1,
  min.normals.betafit = 7,
  min.median.coverage.betafit = 5
)
}
\arguments{
\item{workspace}{Path to the GenomicsDB created by \code{GenomicsDBImport}}

\item{reference.genome}{Reference FASTA file.}

\item{min.normals}{Minimum number of normals with heterozygous SNP for
calculating position-specific mapping bias.}

\item{min.normals.betafit}{Minimum number of normals with heterozygous SNP
fitting a beta distribution}

\item{min.median.coverage.betafit}{Minimum median coverage of normals with
heterozygous SNP for fitting a beta distribution}
}
\value{
A \code{GRanges} object with mapping bias and number of normal
samples with this variant.
}
\description{
Function calculate mapping bias for each variant in the provided
panel of normals GenomicsDB.
}
\examples{

\dontrun{ 
resources_file <- system.file("extdata", "gatk4_pon_db.tgz", 
    package = "PureCN")
tmp_dir <- tempdir()
untar(resources_file, exdir = tmp_dir)
workspace <- file.path(tmp_dir, "gatk4_pon_db")
bias <- calculateMappingBiasGatk4(workspace, "hg19")
saveRDS(bias, "mapping_bias.rds")
unlink(tmp_dir, recursive=TRUE)
}

}
\author{
Markus Riester
}
