\name{makePWMCutoffBackground}
\alias{makePWMCutoffBackground}
\title{Make a cutoff background}
\usage{
  makePWMCutoffBackground(bg.seq, motifs,
    cutoff = log2(exp(4)), bg.pseudo.count = 1,
    bg.source = "", verbose = TRUE)
}
\arguments{
  \item{bg.seq}{a set of background sequences, either a
  list of DNAString object or DNAStringSet object}

  \item{motifs}{a set of motifs, either a list of frequency
  matrices, or a list of PWM objects. If frequency matrices
  are given, the background distribution is fitted from
  bg.seq.}

  \item{cutoff}{the cutoff at which the background should
  be made, i.e. at which a motif hit is called significant}

  \item{bg.pseudo.count}{the pseudo count which is shared
  between nucleotides when frequency matrices are given}

  \item{bg.source}{a free-form textual description of how
  the background was generated}

  \item{verbose}{if to produce verbose output}
}
\description{
  Make a background based on number of motifs hits above a
  certain threshold.
}
\examples{
\dontrun{
if(require("PWMEnrich.Dmelanogaster.background")){
   data(MotifDb.Dmel.PFM)

   # make background for MotifDb motifs using 2kb promoters of all D. melanogaster transcripts using cutoff of 5
	  if(require("BSgenome.Dmelanogaster.UCSC.dm3"))
     makePWMCutoffBackground(Dmelanogaster$upstream2000, MotifDb.Dmel.PFM, cutoff=log2(exp(5)))
}
}
}

