% Generated by roxygen2 (4.0.2): do not edit by hand
\name{toPWM}
\alias{toPWM}
\title{Convert motifs into PWMs}
\usage{
toPWM(motifs, ids = names(motifs), targets = names(motifs),
  seq.count = 50, prior = c(A = 0.25, C = 0.25, G = 0.25, T = 0.25), ...)
}
\arguments{
\item{motifs}{a list of motifs either as position probability matrices (PPM) or frequency matirces (PFMs)}

\item{ids}{the set of IDs for the motifs (defaults to names of the 'motifs' list)}

\item{targets}{the set of target TF names for the motifs (defaults to names of the 'motifs' list)}

\item{seq.count}{provides a vector of sequence counts for probability matrices (PPMs)}

\item{prior}{frequencies of the four letters in the genome. Default is uniform background}

\item{...}{other parameters to PWMUnscaled}
}
\description{
Convert motifs into PWMs
}
\examples{
if(require("PWMEnrich.Dmelanogaster.background")){
   data(MotifDb.Dmel.PFM)

   toPWM(MotifDb.Dmel.PFM) # convert to PWM with uniform background

   prior = getBackgroundFrequencies("dm3", quick=TRUE) # get background for drosophila (quick mode on a reduced dataset)
   toPWM(MotifDb.Dmel.PFM, prior=prior) # convert with genomic background
}
}

