% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPathwayGMT.R
\name{readPathwayGMT}
\alias{readPathwayGMT}
\title{Read Pathway GMT File}
\usage{
readPathwayGMT(file)
}
\arguments{
\item{file}{Path to GMT file}
}
\value{
Data frame of pathway-gene associations
}
\description{
Reads a WikiPathways GMT file to produce a data frame of 
pathway-gene associations useful in enrichment analyses and other 
applications.
}
\details{
The returned data frame includes pathway name, version, identifier,
and organism. The gene content is provided as NCBI Entrez Gene identifiers.
The input file can be retrieved by using 
\code{downloadPathwayArchive(organism="Homo sapiens",format="gmt")}.
}
\examples{
\donttest{
readPathwayGMT(gmt.file)
}
}
\seealso{
downloadPathwayArchive
}
