% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation.R
\name{TCGAvisualize_meanMethylation}
\alias{TCGAvisualize_meanMethylation}
\title{Mean methylation boxplot}
\usage{
TCGAvisualize_meanMethylation(
  data,
  groupCol = NULL,
  subgroupCol = NULL,
  shapes = NULL,
  print.pvalue = FALSE,
  plot.jitter = TRUE,
  jitter.size = 3,
  filename = "groupMeanMet.pdf",
  ylab = expression(paste("Mean DNA methylation (", beta, "-values)")),
  xlab = NULL,
  title = "Mean DNA methylation",
  labels = NULL,
  group.legend = NULL,
  subgroup.legend = NULL,
  color = NULL,
  y.limits = NULL,
  sort,
  order,
  legend.position = "top",
  legend.title.position = "top",
  legend.ncols = 3,
  add.axis.x.text = TRUE,
  width = 10,
  height = 10,
  dpi = 600,
  axis.text.x.angle = 90
)
}
\arguments{
\item{data}{SummarizedExperiment object obtained from TCGAPrepare}

\item{groupCol}{Columns in colData(data) that defines the groups. If no
columns defined a columns called "Patients" will be used}

\item{subgroupCol}{Columns in colData(data) that defines the subgroups.}

\item{shapes}{Shape vector of the subgroups. It must have the size of the levels
of the subgroups. Example: shapes = c(21,23) if for two levels}

\item{print.pvalue}{Print p-value for two groups}

\item{plot.jitter}{Plot jitter? Default TRUE}

\item{jitter.size}{Plot jitter size? Default 3}

\item{filename}{The name of the pdf that will be saved}

\item{ylab}{y axis text in the plot}

\item{xlab}{x axis text in the plot}

\item{title}{main title in the plot}

\item{labels}{Labels of the groups}

\item{group.legend}{Name of the group legend. DEFAULT: groupCol}

\item{subgroup.legend}{Name of the subgroup legend. DEFAULT: subgroupCol}

\item{color}{vector of colors to be used in graph}

\item{y.limits}{Change lower/upper y-axis limit}

\item{sort}{Sort boxplot by mean or median.
Possible values: mean.asc, mean.desc, median.asc, median.desc}

\item{order}{Order of the boxplots}

\item{legend.position}{Legend position ("top", "right","left","bottom")}

\item{legend.title.position}{Legend title position ("top", "right","left","bottom")}

\item{legend.ncols}{Number of columns of the legend}

\item{add.axis.x.text}{Add text to x-axis? Default: FALSE}

\item{width}{Plot width default:10}

\item{height}{Plot height default:10}

\item{dpi}{Pdf dpi default:600}

\item{axis.text.x.angle}{Angle of text in the x axis}
}
\value{
Save the pdf survival plot
}
\description{
Creates a mean methylation boxplot for groups (groupCol),
  subgroups will be highlighted as shapes if the subgroupCol was set.

  Observation: Data is a summarizedExperiment.
}
\examples{
nrows <- 200; ncols <- 21
counts <- matrix(runif(nrows * ncols, 0, 1), nrows)
rowRanges <- GenomicRanges::GRanges(rep(c("chr1", "chr2"), c(50, 150)),
                   IRanges::IRanges(floor(runif(200, 1e5, 1e6)), width=100),
                    strand=sample(c("+", "-"), 200, TRUE),
                    feature_id=sprintf("ID\%03d", 1:200))
colData <- S4Vectors::DataFrame(Treatment=rep(c("ChIP", "Input","Other"), 7),
                    row.names=LETTERS[1:21],
                    group=rep(c("group1","group2","group3"),c(7,7,7)),
                    subgroup=rep(c("subgroup1","subgroup2","subgroup3"),7))
data <- SummarizedExperiment::SummarizedExperiment(
         assays=S4Vectors::SimpleList(counts=counts),
         rowRanges=rowRanges,
         colData=colData)
TCGAvisualize_meanMethylation(data,groupCol  = "group")
# change lower/upper y-axis limit
TCGAvisualize_meanMethylation(data,groupCol  = "group", y.limits = c(0,1))
# change lower y-axis limit
TCGAvisualize_meanMethylation(data,groupCol  = "group", y.limits = 0)
TCGAvisualize_meanMethylation(data,groupCol  = "group", subgroupCol="subgroup")
TCGAvisualize_meanMethylation(data,groupCol  = "group")
TCGAvisualize_meanMethylation(data,groupCol  = "group",sort="mean.desc",filename="meandesc.pdf")
TCGAvisualize_meanMethylation(data,groupCol  = "group",sort="mean.asc",filename="meanasc.pdf")
TCGAvisualize_meanMethylation(data,groupCol  = "group",sort="median.asc",filename="medianasc.pdf")
TCGAvisualize_meanMethylation(data,groupCol  = "group",sort="median.desc",filename="mediandesc.pdf")
}
