% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.matrix.loadings.R
\name{plot.matrix.loadings}
\alias{plot.matrix.loadings}
\title{Plot Residue-Residue Matrix Loadings}
\usage{
\method{plot}{matrix.loadings}(x, pc = 1, resno = NULL, sse = NULL,
  mask.n = 0, plot = TRUE, ...)
}
\arguments{
\item{x}{the results of PCA as obtained from \code{\link{pca.array}}.}

\item{pc}{the principal component along which the loadings will be shown.}

\item{resno}{numerical vector or \sQuote{pdb} object as obtained from \code{\link{read.pdb}}
to show residue number on the x- and y-axis.}

\item{sse}{a \sQuote{sse} object as obtained from \code{\link{dssp}} or \code{\link{stride}}, 
or a \sQuote{pdb} object as obtained from \code{\link{read.pdb}} to show secondary
structural elements along x- and y-axis.}

\item{mask.n}{the number of elements from the diagonal to be masked from output.}

\item{plot}{logical, if FALSE no plot will be shown.}

\item{...}{additional arguments passed to \code{\link{plot.dccm}}.}
}
\value{
Plot and also returns a numeric matrix containing the loadings.
}
\description{
Plot residue-residue matrix loadings of a particular PC that is obtained from a 
principal component analysis (PCA) of cross-correlation or distance matrices.
}
\details{
The function plots loadings (the eigenvectors) of PCA performed on a set of matrices 
such as distance matrices from an ensemble of crystallographic structures 
and residue-residue cross-correlations or covariance matrices derived from 
ensemble NMA or MD simulation replicates (See \code{\link{pca.array}} for detail). 
Loadings are displayed as a matrix with dimension the same as the input matrices 
of the PCA. Each element of loadings represents the proportion that the corresponding 
residue pair contributes to the variance in a particular PC. The plot can be used 
to identify key regions that best explain the variance of underlying matrices.
}
\examples{
\dontrun{
   attach(transducin)
   gaps.res <- gap.inspect(pdbs$ali)
   sse <- pdbs$sse[1, gaps.res$f.inds]

   # calculate modes
   modes <- nma(pdbs, ncore=NULL)

   # calculate cross-correlation matrices from the modes
   cijs <- dccm(modes, ncore=NULL)$all.dccm

   # do PCA on cross-correlation matrices
   pc <- pca.array(cijs)

   # plot loadings
   l <- plot.matrix.loadings(pc, sse=sse)
   l[1:10, 1:10]

   # plot loadings with elements 10-residue separated from diagonal masked
   plot.matrix.loadings(pc, sse=sse, mask.n=10)

}
}
\author{
Xin-Qiu Yao
}
\references{
Skjaerven, L. et al. (2014) \emph{BMC Bioinformatics} \bold{15}, 399.
   Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
}
\seealso{
\code{\link{plot.dccm}}, \code{\link{pca.array}}
}

