% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presets.R
\name{r_vanilla}
\alias{r_vanilla}
\title{Run an R child process, with no configuration}
\usage{
r_vanilla(func, args = list(), libpath = character(), repos = c(CRAN
  = "@CRAN@"), cmdargs = "--slave", system_profile = FALSE,
  user_profile = FALSE, env = character(), ...)
}
\arguments{
\item{func}{Function object to call in the new R process.
The function should be self-contained and only refer to
other functions and use variables explicitly from other packages
using the \code{::} notation. The environment of the function
is set to \code{.GlobalEnv} before passing it to the child process.
Because of this, it is good practice to create an anonymous
function and pass that to \code{callr}, instead of passing
a function object from a (base or other) package. In particular\preformatted{r(.libPaths)
}

does not work, because \code{.libPaths} is defined in a special
environment, but\preformatted{r(function() .libPaths())
}

works just fine.}

\item{args}{Arguments to pass to the function. Must be a list.}

\item{libpath}{The library path.}

\item{repos}{The \code{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{cmdargs}{Command line arguments to pass to the R process.
Note that \code{c("-f", rscript)} is appended to this, \code{rscript}
is the name of the script file to run. This contains a call to the
supplied function and some error handling code.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.}

\item{env}{Environment variables to set for the child process.}

\item{...}{Additional arguments are passed to \code{\link[=r]{r()}}.}
}
\description{
It tries to mimic a fresh R installation. In particular:
\itemize{
\item No library path setting.
\item No CRAN(-like) repository is set.
\item The system and user profiles are not run.
}
}
\examples{
\dontrun{
# Compare to r()
r(function() .libPaths())
r_vanilla(function() .libPaths())

r(function() getOption("repos"))
r_vanilla(function() getOption("repos"))
}
}
\seealso{
Other callr functions: \code{\link{r_copycat}},
  \code{\link{r}}
}
\concept{callr functions}
