\name{Kinship82}
\alias{Kinship82}
\title{Rosenberg-Kim Kinship Terms Partition Data}
\description{
  Partitions of 15 kinship terms given by 85 female undergraduates at
  Rutgers University who were asked to sort the terms into classes
  \dQuote{on the basis of some aspect of meaning}.
}
\usage{data("Kinship82")}
\format{
  A cluster ensemble of 85 hard partitions of the 15 kinship terms.
}
\details{
  Rosenberg and Kim (1975) describe an experiment where perceived
  similarities of the kinship terms were obtained from six different
  \dQuote{sorting} experiments.  These \dQuote{original} Rosenberg-Kim
  kinship terms data were published in Arabie, Carroll and de Sarbo
  (1987), and are also contained in file \file{indclus.data} in the
  shell archive \url{https://netlib.org/mds/indclus.shar}.

  For one of the experiments, partitions of the terms were printed in
  Rosenberg (1982).  Comparison with the original data indicates that
  the partition data have the \dQuote{nephew} and \dQuote{niece} columns
  interchanged, which is corrected in the data set at hand.
}
\source{
  Table 7.1 in Rosenberg (1982), with the \dQuote{nephew} and
  \dQuote{niece} columns interchanged.
}
\references{
  P. Arabie, J. D. Carroll and W. S. de Sarbo (1987).
  \emph{Three-way scaling and clustering}.
  Newbury Park, CA: Sage.
  
  S. Rosenberg and M. P. Kim (1975).
  The method of sorting as a data-gathering procedure in multivariate
  research.
  \emph{Multivariate Behavioral Research}, \bold{10}, 489--502. \cr
  \doi{10.1207/s15327906mbr1004_7}.
  
  S. Rosenberg (1982).
  The method of sorting in multivariate research with applications
  selected from cognitive psychology and person perception.
  In N. Hirschberg and L. G. Humphreys (eds.),
  \emph{Multivariate Applications in the Social Sciences}, 117--142.
  Hillsdale, NJ: Erlbaum.
}
\keyword{datasets}
