print.TGROC<-function(x,...){
  cat("                Sample size:",x$sample.size,"\n")
  cat("          Sample prevalence:",round(x$sample.prevalence,digits = 4),"\n")
  cat("      Population prevalence:",round(x$pop.prevalence,digits = 4)," - same as sample prevalence if not informed\n")
  cat("      Informed cost - FP/FN:",round(x$cost,digits = 4),"\n")
  cat("Informed inconclusive level:",round(x$inc,digits = 4),"\n")
  cat("\n\n")
  cat("Test summary.-------------------------------------------------------------------\n")  
  print(x$test.summary)
  cat("\n\n")
  cat("Non-paramentric inconclusive cut-off limits with",x$inc,"inconclusive tolerance.---\n")  
  print(x$non.parametric.inconclusive)
  cat("\n\n")
  cat("Non-paramentric best cut-off estimations with",x$conf.limit,"confidence limits.------------\n")  
  print(x$np.test.best.cutoff)
  cat("\n\n")
  cat("Paramentric inconclusive cut-off limits with",x$inc,"inconclusive tolerance.--------\n")  
  print(x$parametric.inconclusive)
  cat("\n\n")
  cat("Paramentric best cut-off estimations with",x$conf.limit,"confidence limits.----------------\n")  
  print(x$par.test.best.cutoff)
  cat("\n\n")
}  
