% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_binomial.R
\name{dist_binomial}
\alias{dist_binomial}
\title{The Binomial distribution}
\usage{
dist_binomial(size, prob)
}
\arguments{
\item{size}{The number of trials. Must be an integer greater than or equal
to one. When \code{size = 1L}, the Binomial distribution reduces to the
Bernoulli distribution. Often called \code{n} in textbooks.}

\item{prob}{The probability of success on each trial, \code{prob} can be any
value in \verb{[0, 1]}.}
}
\description{
\lifecycle{stable}
}
\details{
Binomial distributions are used to represent situations can that can
be thought as the result of \eqn{n} Bernoulli experiments (here the
\eqn{n} is defined as the \code{size} of the experiment). The classical
example is \eqn{n} independent coin flips, where each coin flip has
probability \code{p} of success. In this case, the individual probability of
flipping heads or tails is given by the  Bernoulli(p) distribution,
and the probability of having \eqn{x} equal results (\eqn{x} heads,
for example), in \eqn{n} trials is given by the Binomial(n, p) distribution.
The equation of the Binomial distribution is directly derived from
the equation of the Bernoulli distribution.

We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

The Binomial distribution comes up when you are interested in the portion
of people who do a thing. The Binomial distribution
also comes up in the sign test, sometimes called the Binomial test
(see \code{\link[stats:binom.test]{stats::binom.test()}}), where you may need the Binomial C.D.F. to
compute p-values.

In the following, let \eqn{X} be a Binomial random variable with parameter
\code{size} = \eqn{n} and \code{p} = \eqn{p}. Some textbooks define \eqn{q = 1 - p},
or called \eqn{\pi} instead of \eqn{p}.

\strong{Support}: \eqn{\{0, 1, 2, ..., n\}}{{0, 1, 2, ..., n}}

\strong{Mean}: \eqn{np}

\strong{Variance}: \eqn{np \cdot (1 - p) = np \cdot q}{np (1 - p)}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = k) = {n \choose k} p^k (1 - p)^{n-k}
  }{
    P(X = k) = choose(n, k) p^k (1 - p)^(n - k)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le k) = \sum_{i=0}^{\lfloor k \rfloor} {n \choose i} p^i (1 - p)^{n-i}
  }{
    P(X \le k) = \sum_{i=0}^k choose(n, i) p^i (1 - p)^(n-i)
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = (1 - p + p e^t)^n
  }{
    E(e^(tX)) = (1 - p + p e^t)^n
  }
}
\examples{
dist <- dist_binomial(size = 1:5, prob = c(0.05, 0.5, 0.3, 0.9, 0.1))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
