% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_wrap.R
\name{dist_wrap}
\alias{dist_wrap}
\title{Create a distribution from p/d/q/r style functions}
\usage{
dist_wrap(dist, ..., package = NULL)
}
\arguments{
\item{dist}{The name of the distribution used in the functions (name that is
prefixed by p/d/q/r)}

\item{...}{Named arguments used to parameterise the distribution.}

\item{package}{The package from which the distribution is provided. If NULL,
the calling environment's search path is used to find the distribution
functions. Alternatively, an arbitrary environment can also be provided here.}
}
\description{
\lifecycle{experimental}
}
\details{
If a distribution is not yet supported, you can vectorise p/d/q/r functions
using this function. \code{dist_wrap()} stores the distributions parameters, and
provides wrappers which call the appropriate p/d/q/r functions.

Using this function to wrap a distribution should only be done if the
distribution is not yet available in this package. If you need a distribution
which isn't in the package yet, consider making a request at
https://github.com/mitchelloharawild/distributional/issues.
}
\examples{
dist <- dist_wrap("norm", mean = 1:3, sd = c(3, 9, 2))

density(dist, 1) # dnorm()
cdf(dist, 4) # pnorm()
quantile(dist, 0.975) # qnorm()
generate(dist, 10) # rnorm()

library(actuar)
dist <- dist_wrap("invparalogis", package = "actuar", shape = 2, rate = 2)
density(dist, 1) # actuar::dinvparalogis()
cdf(dist, 4) # actuar::pinvparalogis()
quantile(dist, 0.975) # actuar::qinvparalogis()
generate(dist, 10) # actuar::rinvparalogis()

}
