% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiprocess.R
\name{multiprocess}
\alias{multiprocess}
\title{Create a multiprocess future whose value will be resolved asynchronously using multicore or a multisession evaluation}
\usage{
multiprocess(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  lazy = FALSE,
  seed = NULL,
  globals = TRUE,
  workers = availableCores(),
  gc = FALSE,
  earlySignal = FALSE,
  label = NULL,
  ...
)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{seed}{(optional) If TRUE, the random seed, that is, the state of the
random number generator (RNG) will be set such that statistically sound
random numbers are produced (also during parallelization).
If FALSE, it is assumed that the future expression does neither need nor
use random numbers generation.
To use a fixed random seed, specify a L'Ecuyer-CMRG seed (seven integer)
or a regular RNG seed (a single integer).
Furthermore, if FALSE, then the future will be monitored to make sure it
does not use random numbers.  If it does and depending on the value of
option \code{\link[=future.options]{future.rng.misUse}}, the check is
ignored, an informative warning, or error will be produced.
If \code{seed} is NULL (default), then the effect is as with \code{seed = FALSE}
but without the RNG check being performed.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[=future]{future()}}.}

\item{workers}{A positive numeric scalar or a function specifying the
maximum number of parallel futures that can be active at the same time
before blocking.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return a numeric scalar.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{\dots}{Additional named elements passed to \code{\link[=Future]{Future()}}.}
}
\value{
A \link{MultiprocessFuture} implemented as either a
\link{MulticoreFuture} or a \link{MultisessionFuture}.
}
\description{
A multiprocess future is a future that uses \link{multicore} evaluation
if supported, otherwise it uses \link{multisession} evaluation.
Regardless, its \emph{value is computed and resolved in
parallel in another process}.\cr
\cr
\emph{WARNING: Consider the 'multiprocess' future plan deprecated.
Instead, explicitly specify 'multisession' or 'multicore'.  The former works
everywhere and is the recommended one between the two. \emph{Forked processing},
which 'multicore' uses, is unstable in various environment and setups.
The 'multiprocess' alias is therefore being phased out.}
}
\examples{
\donttest{

## Use multiprocess futures
plan(multiprocess)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multiprocess future is evaluated in a separate R process.
## Changing the value of a global variable will not affect
## the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## Explicitly close multisession workers, if they were used
plan(sequential)
}
}
\seealso{
Internally \code{\link[=multicore]{multicore()}} and \code{\link[=multisession]{multisession()}}
are used.
}
\keyword{internal}
