% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_full_bipartite_graph}
\alias{make_full_bipartite_graph}
\alias{graph.full.bipartite}
\alias{full_bipartite_graph}
\title{Create a full bipartite graph}
\usage{
make_full_bipartite_graph(
  n1,
  n2,
  directed = FALSE,
  mode = c("all", "out", "in")
)

full_bipartite_graph(...)
}
\arguments{
\item{n1}{The number of vertices of the first kind.}

\item{n2}{The number of vertices of the second kind.}

\item{directed}{Logical scalar, whether the graphs is directed.}

\item{mode}{Scalar giving the kind of edges to create for directed graphs.
If this is \sQuote{\code{out}} then all vertices of the first kind are
connected to the others; \sQuote{\code{in}} specifies the opposite
direction; \sQuote{\code{all}} creates mutual edges. This argument is
ignored for undirected graphs.x}

\item{...}{Passed to \code{make_full_bipartite_graph}.}
}
\value{
An igraph graph, with the \sQuote{\code{type}} vertex attribute set.
}
\description{
Bipartite graphs are also called two-mode by some. This function creates a
bipartite graph in which every possible edge is present.
}
\details{
Bipartite graphs have a \sQuote{\code{type}} vertex attribute in igraph,
this is boolean and \code{FALSE} for the vertices of the first kind and
\code{TRUE} for vertices of the second kind.
}
\examples{

g <- make_full_bipartite_graph(2, 3)
g2 <- make_full_bipartite_graph(2, 3, dir=TRUE)
g3 <- make_full_bipartite_graph(2, 3, dir=TRUE, mode="in")
g4 <- make_full_bipartite_graph(2, 3, dir=TRUE, mode="all")

}
\seealso{
\code{\link{make_full_graph}} for creating one-mode full graphs
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
