% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{all_simple_paths}
\alias{all_simple_paths}
\title{List all simple paths from one source}
\usage{
all_simple_paths(
  graph,
  from,
  to = V(graph),
  mode = c("out", "in", "all", "total"),
  cutoff = -1
)
}
\arguments{
\item{graph}{The input graph.}

\item{from}{The source vertex.}

\item{to}{The target vertex of vertices. Defaults to all vertices.}

\item{mode}{Character constant, gives whether the shortest paths to or
from the given vertices should be calculated for directed graphs. If
\code{out} then the shortest paths \emph{from} the vertex, if \verb{in}
then \emph{to} it will be considered. If \code{all}, the default, then
the corresponding undirected graph will be used, i.e. not directed paths
are searched. This argument is ignored for undirected graphs.}

\item{cutoff}{Maximum length of path that is considered. If negative, paths of all lengths are considered.}
}
\value{
A list of integer vectors, each integer vector is a path from
the source vertex to one of the target vertices. A path is given by its
vertex ids.
}
\description{
This function lists are simple paths from one source vertex to another
vertex or vertices. A path is simple if the vertices it visits are not
visited more than once.
}
\details{
Note that potentially there are exponentially many paths between two
vertices of a graph, and you may run out of memory when using this
function, if your graph is lattice-like.

This function currently ignored multiple and loop edges.
}
\examples{

g <- make_ring(10)
all_simple_paths(g, 1, 5)
all_simple_paths(g, 1, c(3, 5))

}
\seealso{
Other paths: 
\code{\link{diameter}()},
\code{\link{distance_table}()},
\code{\link{eccentricity}()},
\code{\link{radius}()}
}
\concept{paths}
\keyword{graphs}
