% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{count_automorphisms}
\alias{count_automorphisms}
\title{Number of automorphisms}
\usage{
count_automorphisms(
  graph,
  colors = NULL,
  sh = c("fm", "f", "fs", "fl", "flm", "fsm")
)
}
\arguments{
\item{graph}{The input graph, it is treated as undirected.}

\item{colors}{The colors of the individual vertices of the graph; only
vertices having the same color are allowed to match each other in an
automorphism. When omitted, igraph uses the \code{color} attribute of the
vertices, or, if there is no such vertex attribute, it simply assumes that
all vertices have the same color. Pass NULL explicitly if the graph has a
\code{color} vertex attribute but you do not want to use it.}

\item{sh}{The splitting heuristics for the BLISS algorithm. Possible values
are: \sQuote{\code{f}}: first non-singleton cell, \sQuote{\code{fl}}: first
largest non-singleton cell, \sQuote{\code{fs}}: first smallest non-singleton
cell, \sQuote{\code{fm}}: first maximally non-trivially connected
non-singleton cell, \sQuote{\code{flm}}: first largest maximally
non-trivially connected non-singleton cell, \sQuote{\code{fsm}}: first
smallest maximally non-trivially connected non-singleton cell.}
}
\value{
A named list with the following members: \item{group_size}{The size
of the automorphism group of the input graph, as a string. This number is
exact if igraph was compiled with the GMP library, and approximate
otherwise.} \item{nof_nodes}{The number of nodes in the search tree.}
\item{nof_leaf_nodes}{The number of leaf nodes in the search tree.}
\item{nof_bad_nodes}{Number of bad nodes.} \item{nof_canupdates}{Number of
canrep updates.} \item{max_level}{Maximum level.}
}
\description{
Calculate the number of automorphisms of a graph, i.e. the number of
isomorphisms to itself.
}
\details{
An automorphism of a graph is a permutation of its vertices which brings the
graph into itself.

This function calculates the number of automorphism of a graph using the
BLISS algorithm. See also the BLISS homepage at
\url{http://www.tcs.hut.fi/Software/bliss/index.html}. If you need the
automorphisms themselves, use \code{\link[=automorphism_group]{automorphism_group()}} to obtain
a compact representation of the automorphism group.
}
\examples{

## A ring has n*2 automorphisms, you can "turn" it by 0-9 vertices
## and each of these graphs can be "flipped"
g <- make_ring(10)
count_automorphisms(g)

## A full graph has n! automorphisms; however, we restrict the vertex
## matching by colors, leading to only 4 automorphisms
g <- make_full_graph(4)
count_automorphisms(g, colors = c(1, 2, 1, 2))
}
\references{
Tommi Junttila and Petteri Kaski: Engineering an Efficient
Canonical Labeling Tool for Large and Sparse Graphs, \emph{Proceedings of
the Ninth Workshop on Algorithm Engineering and Experiments and the Fourth
Workshop on Analytic Algorithms and Combinatorics.} 2007.
}
\seealso{
\code{\link[=canonical_permutation]{canonical_permutation()}}, \code{\link[=permute]{permute()}},
and \code{\link[=automorphism_group]{automorphism_group()}} for a compact representation of all
automorphisms

Other graph automorphism: 
\code{\link{automorphism_group}()}
}
\author{
Tommi Junttila (\url{http://users.ics.aalto.fi/tjunttil/}) for BLISS
and Gabor Csardi \email{csardi.gabor@gmail.com} for the igraph glue code
and this manual page.
}
\concept{graph automorphism}
\keyword{graphs}
