% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{get.all.shortest.paths}
\alias{get.all.shortest.paths}
\title{Shortest (directed or undirected) paths between vertices}
\usage{
get.all.shortest.paths(
  graph,
  from,
  to = V(graph),
  mode = c("out", "all", "in"),
  weights = NULL
)
}
\arguments{
\item{graph}{The graph to work on.}

\item{from}{Numeric constant, the vertex from or to the shortest paths will
be calculated. Note that right now this is not a vector of vertex ids, but
only a single vertex.}

\item{to}{Numeric vector, the vertices to which the shortest paths will be
calculated. By default it includes all vertices. Note that for
\code{distances()} every vertex must be included here at most once. (This
is not required for \code{shortest_paths()}.}

\item{mode}{Character constant, gives whether the shortest paths to or from
the given vertices should be calculated for directed graphs. If \code{out}
then the shortest paths \emph{from} the vertex, if \verb{in} then \emph{to}
it will be considered. If \code{all}, the default, then the corresponding
undirected graph will be used, i.e. not directed paths are searched. This
argument is ignored for undirected graphs.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is
\code{NULL} and the graph has a \code{weight} edge attribute, then the
attribute is used. If this is \code{NA} then no weights are used (even if
the graph has a \code{weight} attribute).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{get.all.shortest.paths()} was renamed to \code{all_shortest_paths()} to create a more
consistent API.
}
\keyword{internal}
