% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{permute}
\alias{permute}
\title{Permute the vertices of a graph}
\usage{
permute(graph, permutation)
}
\arguments{
\item{graph}{The input graph, it can directed or undirected.}

\item{permutation}{A numeric vector giving the permutation to apply. The
first element is the new id of vertex 1, etc. Every number between one and
\code{vcount(graph)} must appear exactly once.}
}
\value{
A new graph object.
}
\description{
Create a new graph, by permuting vertex ids.
}
\details{
This function creates a new graph from the input graph by permuting its
vertices according to the specified mapping. Call this function with the
output of \code{\link[=canonical_permutation]{canonical_permutation()}} to create the canonical form
of a graph.

\code{permute()} keeps all graph, vertex and edge attributes of the graph.
}
\examples{

# Random permutation of a random graph
g <- sample_gnm(20, 50)
g2 <- permute(g, sample(vcount(g)))
graph.isomorphic(g, g2)

# Permutation keeps all attributes
g$name <- "Random graph, Gnm, 20, 50"
V(g)$name <- letters[1:vcount(g)]
E(g)$weight <- sample(1:5, ecount(g), replace = TRUE)
g2 <- permute(g, sample(vcount(g)))
graph.isomorphic(g, g2)
g2$name
V(g2)$name
E(g2)$weight
all(sort(E(g2)$weight) == sort(E(g)$weight))
}
\seealso{
\code{\link[=canonical_permutation]{canonical_permutation()}}

Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{complementer}()},
\code{\link{compose}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference}()},
\code{\link{difference.igraph}()},
\code{\link{disjoint_union}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection}()},
\code{\link{intersection.igraph}()},
\code{\link{path}()},
\code{\link{rep.igraph}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union}()},
\code{\link{union.igraph}()},
\code{\link{vertex}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{functions for manipulating graph structure}
\keyword{graphs}
