% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score2.R
\name{score2}
\alias{score2}
\alias{score2.lm}
\alias{score2.gls}
\alias{score2.lme}
\alias{score2.lvmfit}
\alias{score2.lm2}
\alias{score2.gls2}
\alias{score2.lme2}
\alias{score2.lvmfit2}
\title{Extract the Individual Score}
\usage{
score2(object, ...)

\method{score2}{lm}(object, param = NULL, data = NULL,
  bias.correct = TRUE, ...)

\method{score2}{gls}(object, param = NULL, data = NULL,
  bias.correct = TRUE, ...)

\method{score2}{lme}(object, param = NULL, data = NULL,
  bias.correct = TRUE, ...)

\method{score2}{lvmfit}(object, param = NULL, data = NULL,
  bias.correct = TRUE, ...)

\method{score2}{lm2}(object, param = NULL, data = NULL, ...)

\method{score2}{gls2}(object, param = NULL, data = NULL, ...)

\method{score2}{lme2}(object, param = NULL, data = NULL, ...)

\method{score2}{lvmfit2}(object, param = NULL, data = NULL, ...)
}
\arguments{
\item{object}{a linear model or a latent variable model}

\item{...}{arguments to be passed to \code{sCorrect}.}

\item{param}{[optional] the fitted parameters.}

\item{data}{[optional] the data set.}

\item{bias.correct}{[logical] should the standard errors of the coefficients be corrected for small sample bias? Only relevant if the \code{sCorrect} function has not yet be applied to the object.}
}
\value{
A matrix containing the score relative to each sample (in rows)
and each model coefficient (in columns).
}
\description{
Extract the individual score from a Gaussian linear model.
}
\details{
If argument \code{p} or \code{data} is not null, then the small sample size correction is recomputed to correct the influence function.
}
\examples{
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- Sequence.lvm(0)
set.seed(10)
d <- lava::sim(m,n)

## linear model
e.lm <- lm(formula.lvm,data=d)
score.tempo <- score2(e.lm, bias.correct = FALSE)
colMeans(score.tempo)

## latent variable model
e.lvm <- estimate(lvm(formula.lvm),data=d)
score.tempo <- score2(e.lvm, bias.correct = FALSE)
range(score.tempo-score(e.lvm, indiv = TRUE))

}
\seealso{
\code{\link{sCorrect}} to obtain \code{lm2}, \code{gls2}, \code{lme2}, or \code{lvmfit2} objects.
}
\concept{small sample inference}
