% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimp.R
\name{nimp}
\alias{nimp}
\title{Number of imputations per block}
\usage{
nimp(where, blocks = make.blocks(where))
}
\arguments{
\item{where}{A data frame or matrix with logicals of the same dimensions
as \code{data} indicating where in the data the imputations should be
created. The default, \code{where = is.na(data)}, specifies that the
missing data should be imputed. The \code{where} argument may be used to
overimpute observed data, or to skip imputations for selected missing values.}

\item{blocks}{List of vectors with variable names per block. List elements
may be named to identify blocks. Variables within a block are
imputed by a multivariate imputation method
(see \code{method} argument). By default each variable is placed
into its own block, which is effectively
fully conditional specification (FCS) by univariate models
(variable-by-variable imputation). Only variables whose names appear in
\code{blocks} are imputed. The relevant columns in the \code{where}
matrix are set to \code{FALSE} of variables that are not block members.
A variable may appear in multiple blocks. In that case, it is
effectively re-imputed each time that it is visited.}
}
\value{
A numeric vector of length \code{length(blocks)} containing
the number of cells that need to be imputed within a block.
}
\description{
Calculates the number of cells within a block for which imputation
is requested.
}
\examples{
where <- is.na(nhanes)

# standard FCS
nimp(where)

# user-defined blocks
nimp(where, blocks = name.blocks(list(c("bmi", "hyp"), "age", "chl")))
}
\seealso{
\code{\link{mice}}
}
