% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task_operators.R
\name{getTaskTargets}
\alias{getTaskTargets}
\title{Get target data of task.}
\usage{
getTaskTargets(task, recode.target = "no")
}
\arguments{
\item{task}{(\link{Task})\cr
The task.}

\item{recode.target}{(\code{character(1)})\cr
Should target classes be recoded? Supported are binary and multilabel classification and survival.
Possible values for binary classification are \dQuote{01}, \dQuote{-1+1} and \dQuote{drop.levels}.
In the two latter cases the target vector is converted into a numeric vector.
The positive class is coded as \dQuote{+1} and the negative class either as \dQuote{0} or \dQuote{-1}.
\dQuote{drop.levels} will remove empty factor levels in the target column.
In the multilabel case the logical targets can be converted to factors with \dQuote{multilabel.factor}.
For survival, you may choose to recode the survival times to \dQuote{left}, \dQuote{right} or \dQuote{interval2} censored times
using \dQuote{lcens}, \dQuote{rcens} or \dQuote{icens}, respectively.
See \link[survival:Surv]{survival::Surv} for the format specification.
Default for both binary classification and survival is \dQuote{no} (do nothing).}
}
\value{
A \code{factor} for classification or a \code{numeric} for regression, a data.frame
of logical columns for multilabel.
}
\description{
Get target data of task.
}
\examples{
task = makeClassifTask(data = iris, target = "Species")
getTaskTargets(task)
}
\seealso{
Other task: 
\code{\link{getTaskClassLevels}()},
\code{\link{getTaskCosts}()},
\code{\link{getTaskData}()},
\code{\link{getTaskDesc}()},
\code{\link{getTaskFeatureNames}()},
\code{\link{getTaskFormula}()},
\code{\link{getTaskId}()},
\code{\link{getTaskNFeats}()},
\code{\link{getTaskSize}()},
\code{\link{getTaskTargetNames}()},
\code{\link{getTaskType}()},
\code{\link{subsetTask}()}
}
\concept{task}
