% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_FactoMineR.R, R/methods_lavaan.R,
%   R/methods_psych.R, R/methods_sem.R
\name{model_parameters.PCA}
\alias{model_parameters.PCA}
\alias{model_parameters.FAMD}
\alias{model_parameters.lavaan}
\alias{model_parameters.principal}
\alias{model_parameters.omega}
\alias{model_parameters.sem}
\title{Parameters from PCA, FA, CFA, SEM}
\usage{
\method{model_parameters}{PCA}(
  model,
  sort = FALSE,
  threshold = NULL,
  labels = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{FAMD}(
  model,
  sort = FALSE,
  threshold = NULL,
  labels = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{lavaan}(
  model,
  ci = 0.95,
  standardize = FALSE,
  component = c("regression", "correlation", "loading", "defined"),
  keep = NULL,
  drop = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{principal}(
  model,
  sort = FALSE,
  threshold = NULL,
  labels = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{omega}(model, verbose = TRUE, ...)

\method{model_parameters}{sem}(
  model,
  ci = 0.95,
  ci_method = NULL,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  summary = getOption("parameters_summary", FALSE),
  keep = NULL,
  drop = NULL,
  verbose = TRUE,
  vcov = NULL,
  vcov_args = NULL,
  ...
)
}
\arguments{
\item{model}{Model object.}

\item{sort}{Sort the loadings.}

\item{threshold}{A value between 0 and 1 indicates which (absolute) values
from the loadings should be removed. An integer higher than 1 indicates the
n strongest loadings to retain. Can also be \code{"max"}, in which case it
will only display the maximum loading per variable (the most simple
structure).}

\item{labels}{A character vector containing labels to be added to the
loadings data. Usually, the question related to the item.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{standardize}{Return standardized parameters (standardized coefficients).
Can be \code{TRUE} (or \code{"all"} or \code{"std.all"}) for standardized
estimates based on both the variances of observed and latent variables;
\code{"latent"} (or \code{"std.lv"}) for standardized estimates based
on the variances of the latent variables only; or \code{"no_exogenous"}
(or \code{"std.nox"}) for standardized estimates based on both the
variances of observed and latent variables, but not the variances of
exogenous covariates. See \code{lavaan::standardizedsolution} for details.}

\item{component}{What type of links to return. Can be \code{"all"} or some of
\code{c("regression", "correlation", "loading", "variance", "mean")}.}

\item{keep}{Character containing a regular expression pattern that
describes the parameters that should be included (for \code{keep}) or excluded
(for \code{drop}) in the returned data frame. \code{keep} may also be a
named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{keep} is a character vector, every parameter
name in the \emph{"Parameter"} column that matches the regular expression in
\code{keep} will be selected from the returned data frame (and vice versa,
all parameter names matching \code{drop} will be excluded). Furthermore, if
\code{keep} has more than one element, these will be merged with an \code{OR}
operator into a regular expression pattern like this: \code{"(one|two|three)"}.
If \code{keep} is a named list of regular expression patterns, the names of the
list-element should equal the column name where selection should be
applied. This is useful for model objects where \code{model_parameters()}
returns multiple columns with parameter components, like in
\code{\link[=model_parameters.lavaan]{model_parameters.lavaan()}}. Note that the regular expression pattern
should match the parameter names as they are stored in the returned data
frame, which can be different from how they are printed. Inspect the
\verb{$Parameter} column of the parameters table to get the exact parameter
names.}

\item{drop}{See \code{keep}.}

\item{ci_method}{Method for computing degrees of freedom for
confidence intervals (CI) and the related p-values. Allowed are following
options (which vary depending on the model class): \code{"residual"},
\code{"normal"}, \code{"likelihood"}, \code{"satterthwaite"}, \code{"kenward"}, \code{"wald"},
\code{"profile"}, \code{"boot"}, \code{"uniroot"}, \code{"ml1"}, \code{"betwithin"}, \code{"hdi"},
\code{"quantile"}, \code{"ci"}, \code{"eti"}, \code{"si"}, \code{"bci"}, or \code{"bcai"}. See section
\emph{Confidence intervals and approximation of degrees of freedom} in
\code{\link[=model_parameters]{model_parameters()}} for further details. When \code{ci_method=NULL}, in most
cases \code{"wald"} is used then.}

\item{bootstrap}{Should estimates be based on bootstrapped model? If
\code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the
case of bootstrapped frequentist models.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log or
logit links. It is also recommended to use \code{exponentiate = TRUE} for models
with log-transformed response values. \strong{Note:} Delta-method standard
errors are also computed (by multiplying the standard errors by the
transformed coefficients). This is to mimic behaviour of other software
packages, such as Stata, but these standard errors poorly estimate
uncertainty for the transformed coefficient. The transformed confidence
interval more clearly captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients from
non-Gaussian families.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats:p.adjust]{stats::p.adjust()}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \strong{emmeans}).}

\item{summary}{Logical, if \code{TRUE}, prints summary information about the
model (model formula, number of observations, residual standard deviation
and more).}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance matrix,
a function which returns a covariance matrix, or a string which identifies
the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"vcovHC"}, \code{"HC"}, \code{"HC0"}, \code{"HC1"},
\code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}.
\item Cluster-robust: \code{"vcovCR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"}, \code{"CR2"},
\code{"CR3"}. See \code{?clubSandwich::vcovCR}.
\item Bootstrap: \code{"vcovBS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"}, \code{"webb"}.
See \code{?sandwich::vcovBS}.
\item Other \code{sandwich} package functions: \code{"vcovHAC"}, \code{"vcovPC"}, \code{"vcovCL"}, \code{"vcovPL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the \strong{sandwich}
or \strong{clubSandwich} packages. Please refer to their documentation (e.g.,
\code{?sandwich::vcovHAC}) to see the list of available arguments.}
}
\value{
A data frame of indices or loadings.
}
\description{
Format structural models from the \strong{psych} or \strong{FactoMineR} packages.
}
\details{
For the structural models obtained with \strong{psych}, the following indices
are present:
\itemize{
\item \strong{Complexity} (\cite{Hoffman's, 1978; Pettersson and Turkheimer,
2010}) represents the number of latent components needed to account for
the observed variables. Whereas a perfect simple structure solution has a
complexity of 1 in that each item would only load on one factor, a
solution with evenly distributed items has a complexity greater than 1.
\item \strong{Uniqueness} represents the variance that is 'unique' to the
variable and not shared with other variables. It is equal to \verb{1 – communality} (variance that is shared with other variables). A uniqueness
of \code{0.20} suggests that \verb{20\%} or that variable's variance is not shared
with other variables in the overall factor model. The greater 'uniqueness'
the lower the relevance of the variable in the factor model.
\item \strong{MSA} represents the Kaiser-Meyer-Olkin Measure of Sampling
Adequacy (\cite{Kaiser and Rice, 1974}) for each item. It indicates
whether there is enough data for each factor give reliable results for the
PCA. The value should be > 0.6, and desirable values are > 0.8
(\cite{Tabachnick and Fidell, 2013}).
}
}
\note{
There is also a
\href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method}
for \code{lavaan} models implemented in the
\href{https://easystats.github.io/see/}{\strong{see}-package}.
}
\examples{
\donttest{
library(parameters)
if (require("psych", quietly = TRUE)) {
  # Principal Component Analysis (PCA) ---------
  pca <- psych::principal(attitude)
  model_parameters(pca)

  pca <- psych::principal(attitude, nfactors = 3, rotate = "none")
  model_parameters(pca, sort = TRUE, threshold = 0.2)

  principal_components(attitude, n = 3, sort = TRUE, threshold = 0.2)


  # Exploratory Factor Analysis (EFA) ---------
  efa <- psych::fa(attitude, nfactors = 3)
  model_parameters(efa,
    threshold = "max", sort = TRUE,
    labels = as.character(1:ncol(attitude))
  )


  # Omega ---------
  omega <- psych::omega(mtcars, nfactors = 3)
  params <- model_parameters(omega)
  params
  summary(params)
}
}

# lavaan

library(parameters)

# lavaan -------------------------------------
if (require("lavaan", quietly = TRUE)) {
  # Confirmatory Factor Analysis (CFA) ---------

  structure <- " visual  =~ x1 + x2 + x3
                 textual =~ x4 + x5 + x6
                 speed   =~ x7 + x8 + x9 "
  model <- lavaan::cfa(structure, data = HolzingerSwineford1939)
  model_parameters(model)
  model_parameters(model, standardize = TRUE)

  # filter parameters
  model_parameters(
    model,
    parameters = list(
      To = "^(?!visual)",
      From = "^(?!(x7|x8))"
    )
  )

  # Structural Equation Model (SEM) ------------

  structure <- "
    # latent variable definitions
      ind60 =~ x1 + x2 + x3
      dem60 =~ y1 + a*y2 + b*y3 + c*y4
      dem65 =~ y5 + a*y6 + b*y7 + c*y8
    # regressions
      dem60 ~ ind60
      dem65 ~ ind60 + dem60
    # residual correlations
      y1 ~~ y5
      y2 ~~ y4 + y6
      y3 ~~ y7
      y4 ~~ y8
      y6 ~~ y8
  "
  model <- lavaan::sem(structure, data = PoliticalDemocracy)
  model_parameters(model)
  model_parameters(model, standardize = TRUE)
}

}
\references{
\itemize{
\item Kaiser, H.F. and Rice. J. (1974). Little jiffy, mark iv. Educational and
Psychological Measurement, 34(1):111–117
\item Pettersson, E., and Turkheimer, E. (2010). Item selection, evaluation, and
simple structure in personality data. Journal of research in personality,
44(4), 407-420.
\item Revelle, W. (2016). How To: Use the psych package for Factor Analysis and
data reduction.
\item Tabachnick, B. G., and Fidell, L. S. (2013). Using multivariate statistics
(6th ed.). Boston: Pearson Education.
\item Rosseel Y (2012). lavaan: An R Package for Structural Equation
Modeling. Journal of Statistical Software, 48(2), 1-36.
\item Merkle EC , Rosseel Y (2018). blavaan: Bayesian Structural Equation
Models via Parameter Expansion. Journal of Statistical Software, 85(4),
1-30. http://www.jstatsoft.org/v85/i04/
}
}
