% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_xu.R
\name{r2_xu}
\alias{r2_xu}
\title{Xu' R2 (Omega-squared)}
\usage{
r2_xu(model)
}
\arguments{
\item{model}{A linear (mixed) model.}
}
\value{
The R2 value.
}
\description{
Calculates Xu' Omega-squared value, a simple R2 equivalent for linear mixed models.
}
\details{
\code{r2_xu()} is a crude measure for the explained variance from
  linear (mixed) effects models, which is originally denoted as
  \ifelse{html}{\out{&Omega;<sup>2</sup>}}{\eqn{\Omega^2}}.
}
\examples{
model <- lm(Sepal.Length ~ Petal.Length + Species, data = iris)
r2_xu(model)

}
\references{
Xu, R. (2003). Measuring explained variation in linear mixed effects models. Statistics in Medicine, 22(22), 3527–3541. \doi{10.1002/sim.1572}
}
