% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-dll.R
\name{compile_dll}
\alias{compile_dll}
\title{Compile a .dll/.so from source.}
\usage{
compile_dll(
  path = ".",
  force = FALSE,
  compile_attributes = pkg_links_to_cpp11(path) || pkg_links_to_rcpp(path),
  register_routines = FALSE,
  quiet = FALSE,
  debug = TRUE
)
}
\arguments{
\item{path}{Path to a package, or within a package.}

\item{force}{If \code{TRUE}, for compilation even if \code{\link[=needs_compile]{needs_compile()}} is
\code{FALSE}.}

\item{compile_attributes}{if \code{TRUE} and the package uses Rcpp, call
\code{\link[Rcpp:compileAttributes]{Rcpp::compileAttributes()}} before building the package. It is ignored
if package does not need compilation.}

\item{register_routines}{if \code{TRUE} and the package does not use Rcpp, call
register routines with
\code{tools::package_native_routine_registration_skeleton()} before building
the package. It is ignored if package does not need compilation.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{debug}{If \code{TRUE}, and if no user Makevars is found, then the build
runs without optimisation (\code{-O0}) and with debug symbols (\code{-g}). See
\code{\link[=compiler_flags]{compiler_flags()}} for details. If you have a user Makevars (e.g.,
\verb{~/.R/Makevars}) then this argument is ignored.}
}
\description{
\code{compile_dll} performs a fake R CMD install so code that
works here should work with a regular install (and vice versa).
During compilation, debug flags are set with
\code{\link{compiler_flags}(TRUE)}.
}
\details{
Invisibly returns the names of the DLL.
\subsection{Configuration}{
\subsection{Options}{
\itemize{
\item \code{pkg.build_extra_flags}: set this to \code{FALSE} to to opt out from adding
debug compiler flags in \code{compile_dll()}. Takes precedence over the
\code{PKG_BUILD_EXTRA_FLAGS} environment variable. Possible values:
\itemize{
\item \code{TRUE}: add extra flags,
\item \code{FALSE}: do not add extra flags,
\item \code{"missing"}: add extra flags if the user does not have a
\verb{$HOME/.R/Makevars} file.
}
}
}

\subsection{Environment variables}{
\itemize{
\item \code{PKG_BUILD_EXTRA_FLAGS}: set this to \code{false} to to opt out from adding
debug compiler flags in \code{compile_dll()}. The \code{pkg.build_extra_flags} option
takes precedence over this environment variable. Possible values:
\itemize{
\item \code{"true"}: add extra flags,
\item \code{"false"}: do not add extra flags,
\item \code{"missing"}: add extra flags if the user does not have a
\verb{$HOME/.R/Makevars} file.
}
}
}

}
}
\note{
If this is used to compile code that uses Rcpp, you will need to
add the following line to your \code{Makevars} file so that it
knows where to find the Rcpp headers:
\verb{PKG_CPPFLAGS=}$(R_HOME)/bin/Rscript -e 'Rcpp:::CxxFlags()'``
}
\seealso{
\code{\link[=clean_dll]{clean_dll()}} to delete the compiled files.
}
