% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_progress.R, R/without_progress.R
\name{with_progress}
\alias{with_progress}
\alias{without_progress}
\title{Report on Progress while Evaluating an R Expression}
\usage{
with_progress(
  expr,
  handlers = progressr::handlers(),
  cleanup = TRUE,
  delay_terminal = NULL,
  delay_stdout = NULL,
  delay_conditions = NULL,
  interrupts = getOption("progressr.interrupts", TRUE),
  interval = NULL,
  enable = NULL
)

without_progress(expr)
}
\arguments{
\item{expr}{An \R expression to evaluate.}

\item{handlers}{A progression handler or a list of them.
If NULL or an empty list, progress updates are ignored.}

\item{cleanup}{If TRUE, all progression handlers will be shutdown
at the end regardless of the progression is complete or not.}

\item{delay_terminal}{If TRUE, output and conditions that may end up in
the terminal will delayed.}

\item{delay_stdout}{If TRUE, standard output is captured and relayed
at the end just before any captured conditions are relayed.}

\item{delay_conditions}{A character vector specifying \link[base:conditions]{base::condition}
classes to be captured and relayed at the end after any captured
standard output is relayed.}

\item{interrupts}{Controls whether interrupts should be detected or not.
If TRUE and a interrupt is signaled, progress handlers are asked to
report on the current amount progress when the evaluation was terminated
by the interrupt, e.g. when a user pressed Ctrl-C in an interactive session,
or a batch process was interrupted because it ran out of time.}

\item{interval}{(numeric) The minimum time (in seconds) between
successive progression updates from handlers.}

\item{enable}{(logical) If FALSE, then progress is not reported.  The
default is to report progress in interactive mode but not batch mode.
See below for more details.}
}
\value{
Returns the value of the expression.
}
\description{
Report on Progress while Evaluating an R Expression
}
\details{
\emph{IMPORTANT: This function is meant for end users only.  It should not
be used by R packages, which only task is to \emph{signal} progress updates,
not to decide if, when, and how progress should be reported.}

\code{without_progress()} evaluates an expression while ignoring all
progress updates.
}
\section{Progression handler functions}{

Formally, progression handlers are calling handlers that are called
when a \link{progression} condition is signaled.  These handlers are functions
that takes one argument which is the \link{progression} condition.
}

\section{Progress updates in batch mode}{

When running R from the command line, R runs in a non-interactive mode
(\code{interactive()} returns \code{FALSE}).  The default behavior of
\code{with_progress()} is to \emph{not} report on progress in non-interactive mode.
To have progress being reported on also then, set R options
\option{progressr.enable} or environment variable \env{R_PROGRESSR_ENABLE}
to \code{TRUE}.  Alternatively, one can set argument \code{enable=TRUE} when calling
\code{with_progress()}.  For example,

\if{html}{\out{<div class="sourceCode sh">}}\preformatted{$ Rscript -e "library(progressr)" -e "with_progress(slow_sum(1:5))"
}\if{html}{\out{</div>}}

will \emph{not} report on progress, whereas:

\if{html}{\out{<div class="sourceCode sh">}}\preformatted{$ export R_PROGRESSR_ENABLE=TRUE
$ Rscript -e "library(progressr)" -e "with_progress(slow_sum(1:5))"
}\if{html}{\out{</div>}}

will.
}

\examples{
## The slow_sum() example function
slow_sum <- progressr::slow_sum
print(slow_sum)

x <- 1:10

## Without progress updates
y <- slow_sum(x)


## Progress reported via txtProgressBar (default)
handlers("txtprogressbar")  ## default
with_progress({
  y <- slow_sum(x)
})

## Progress reported via tcltk::tkProgressBar
if (capabilities("tcltk") && requireNamespace("tcltk", quietly = TRUE)) {
  handlers("tkprogressbar")
  with_progress({
    y <- slow_sum(x)
  })
}

## Progress reported via progress::progress_bar)
if (requireNamespace("progress", quietly = TRUE)) {
  handlers("progress")
  with_progress({
    y <- slow_sum(x)
  })
}

## Progress reported via txtProgressBar and beepr::beep
if (requireNamespace("beepr", quietly = TRUE)) {
  handlers("beepr", "txtprogressbar")
  with_progress({
    y <- slow_sum(x)
  })
}

## Progress reported via customized utils::txtProgressBar and beepr::beep,
## if available.
handlers(handler_txtprogressbar(style = 3L))
if (requireNamespace("beepr", quietly = TRUE)) {
  handlers("beepr", append = TRUE)
}

with_progress({
  y <- slow_sum(1:30)
})
}
\seealso{
\code{\link[base:conditions]{base::withCallingHandlers()}}
}
