% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_shiny.R
\name{handler_shiny}
\alias{handler_shiny}
\title{Progression Handler: Progress Reported via 'shiny' Widgets (GUI) in the HTML Browser}
\usage{
handler_shiny(
  intrusiveness = getOption("progressr.intrusiveness.gui", 1),
  target = "gui",
  inputs = list(message = NULL, detail = "message"),
  enable = getOption("progressr.enable", TRUE),
  ...
)
}
\arguments{
\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{inputs}{(named list) Specifies from what sources the Shiny progress
elements 'message' and 'detail' should be updated.  Valid sources are
\code{"message"}, \code{"sticky_message"} and \code{"non_sticky_message"}, where
\code{"message"} is short for \code{c("non_sticky_message", "sticky_message")}. For
example, \code{inputs = list(message = "sticky_message", detail = "message")}
will update the Shiny 'message' component from sticky messages only,
whereas the 'detail' component is updated using any message.}

\item{enable}{(logical) If FALSE, then progress is not reported.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \pkg{shiny} and \code{\link[shiny:withProgress]{shiny::withProgress()}}.
}
\details{
For most Shiny application there is little need to use this Shiny handler
directly.  Instead, it is sufficient to use \code{\link[=withProgressShiny]{withProgressShiny()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{shiny} package.
}

\examples{
\donttest{\dontrun{
handlers(handler_shiny())
with_progress(y <- slow_sum(1:100))
}}

}
\keyword{internal}
