% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_mapper.R
\name{as_mapper}
\alias{as_mapper}
\alias{as_function}
\alias{as_mapper.character}
\alias{as_mapper.numeric}
\alias{as_mapper.list}
\title{Convert an object into a mapper function}
\usage{
as_mapper(.f, ...)

\method{as_mapper}{character}(.f, ..., .null, .default = NULL)

\method{as_mapper}{numeric}(.f, ..., .null, .default = NULL)

\method{as_mapper}{list}(.f, ..., .null, .default = NULL)
}
\arguments{
\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to methods.}

\item{.default, .null}{Optional additional argument for extractor functions
(i.e. when \code{.f} is character, integer, or list). Returned when
value is absent (does not exist) or empty (has length 0).
\code{.null} is deprecated; please use \code{.default} instead.}
}
\description{
\code{as_mapper} is the powerhouse behind the varied function
specifications that most purrr functions allow. It is an S3
generic. The default method forwards its arguments to
\code{\link[rlang:as_function]{rlang::as_function()}}.
}
\examples{
as_mapper(~ . + 1)
as_mapper(1)

as_mapper(c("a", "b", "c"))
# Equivalent to function(x) x[["a"]][["b"]][["c"]]

as_mapper(list(1, "a", 2))
# Equivalent to function(x) x[[1]][["a"]][[2]]

as_mapper(list(1, attr_getter("a")))
# Equivalent to function(x) attr(x[[1]], "a")

as_mapper(c("a", "b", "c"), .null = NA)
}
