% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline_monotone.R
\name{step_spline_monotone}
\alias{step_spline_monotone}
\title{Monotone Splines}
\usage{
step_spline_monotone(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  deg_free = 10,
  degree = 3,
  complete_set = TRUE,
  options = NULL,
  keep_original_cols = FALSE,
  results = NULL,
  skip = FALSE,
  id = rand_id("spline_monotone")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{deg_free}{The degrees of freedom for the b-spline. As the
degrees of freedom for a b-spline increase, more flexible and
complex curves can be generated.}

\item{degree}{The degree of I-spline defined to be the degree of the
associated M-spline instead of actual polynomial degree. For example,
I-spline basis of degree 2 is defined as the integral of associated M-spline
basis of degree 2.}

\item{complete_set}{If \code{TRUE}, the complete basis matrix will be returned.
Otherwise, the first basis will be excluded from the output. This maps to
the \code{intercept} argument of the corresponding function from the
\pkg{splines2} package and has the same default value.}

\item{options}{A list of options for \code{\link[splines2:iSpline]{splines2::iSpline()}}
which should not include \code{x}, \code{df}, \code{degree}, \code{periodic}, or \code{intercept}.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{results}{A list of objects created once the step has been trained.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object with classes \code{"step_spline_monotone"} and \code{"step"}.
}
\description{
\code{step_spline_monotone} creates a \emph{specification} of a recipe
step that creates monotone spline features.
}
\details{
Spline transformations take a numeric column and create multiple features
that, when used in a model, can estimate nonlinear trends between the column
and some outcome. The degrees of freedom determines how many new features
are added to the data.

These splines are integrated forms of M-splines and are non-negative and
monotonic. This means that, when used with a fitting function that produces
non-negative regression coefficients, the resulting fit is monotonic.

If the spline expansion fails for a selected column, the step will
remove that column's results (but will retain the original data). Use the
\code{tidy()} method to determine which columns were used.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with column
\code{terms} (the columns that will be affected) is returned.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed(c("modeldata", "ggplot2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tidyr)
library(dplyr)

library(ggplot2)
data(ames, package = "modeldata")

spline_rec <- recipe(Sale_Price ~ Longitude, data = ames) \%>\%
  step_spline_monotone(Longitude, deg_free = 6, keep_original_cols = TRUE) \%>\%
  prep()

tidy(spline_rec, number = 1)

# Show where each feature is active
spline_rec \%>\%
  bake(new_data =  NULL,-Sale_Price) \%>\%
  pivot_longer(c(starts_with("Longitude_")), names_to = "feature", values_to = "value") \%>\%
  mutate(feature = gsub("Longitude_", "feature ", feature)) \%>\%
  filter(value > 0) \%>\%
  ggplot(aes(x = Longitude, y = value)) +
  geom_line() +
  facet_wrap(~ feature)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[splines2:iSpline]{splines2::iSpline()}}
}
