% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reprex_document.R
\name{reprex_document}
\alias{reprex_document}
\title{reprex output format}
\usage{
reprex_document(
  venue = c("gh", "r", "rtf", "html", "slack", "so", "ds"),
  advertise = NULL,
  session_info = opt(FALSE),
  style = opt(FALSE),
  comment = opt("#>"),
  tidyverse_quiet = opt(TRUE),
  std_out_err = opt(FALSE),
  pandoc_args = NULL
)
}
\arguments{
\item{venue}{Character. Must be one of the following (case insensitive):
\itemize{
\item "gh" for \href{https://github.github.com/gfm/}{GitHub-Flavored Markdown}, the
default
\item "r" for a runnable R script, with commented output interleaved. Also useful
for \href{https://slack.com/intl/en-ca/slack-tips/share-code-snippets}{Slack code snippets};
select "R" from the "Type" drop-down menu to enjoy nice syntax
highlighting.
\item "rtf" for
\href{https://en.wikipedia.org/wiki/Rich_Text_Format}{Rich Text Format}
(not supported for un-reprexing)
\item "html" for an HTML fragment suitable for inclusion in a larger HTML
document (not supported for un-reprexing)
\item "slack" for pasting into a Slack message. Optimized for people who opt out
of Slack's WYSIWYG interface. Go to
\strong{Preferences > Advanced > Input options} and select "Format messages with
markup". (If there is demand for a second Slack venue optimized for use
with WYSIWYG, please open an issue to discuss.)
\item "so" for
\href{https://stackoverflow.com/editing-help#syntax-highlighting}{Stack Overflow Markdown}.
Note: this is just an alias for "gh", since Stack Overflow started to
support CommonMark-style fenced code blocks in January 2019.
\item "ds" for Discourse, e.g.,
\href{https://community.rstudio.com}{community.rstudio.com}. Note: this is
currently just an alias for "gh".
}}

\item{advertise}{Logical. Whether to include a footer that describes when and
how the reprex was created. If unspecified, the option \code{reprex.advertise}
is consulted and, if that is not defined, default is \code{TRUE} for venues
\code{"gh"}, \code{"html"}, \code{"so"}, \code{"ds"} and \code{FALSE} for \code{"r"}, \code{"rtf"}, \code{"slack"}.}

\item{session_info}{Logical. Whether to include
\code{\link[sessioninfo:session_info]{sessioninfo::session_info()}}, if available, or \code{\link[=sessionInfo]{sessionInfo()}} at the end
of the reprex. When \code{venue} is "gh", the session info is wrapped in a
collapsible details tag. Read more about \code{\link[=opt]{opt()}}.}

\item{style}{Logical. Whether to set the knitr chunk option \code{tidy = "styler"}, which re-styles code with the \href{https://styler.r-lib.org}{styler package}. Read more about \code{\link[=opt]{opt()}}.}

\item{comment}{Character. Prefix with which to comment out output, defaults
to \code{"#>"}. Read more about \code{\link[=opt]{opt()}}.}

\item{tidyverse_quiet}{Logical. Sets the options \code{tidyverse.quiet} and
\code{tidymodels.quiet}, which suppress (\code{TRUE}, the default) or include
(\code{FALSE}) the startup messages for the tidyverse and tidymodels packages.
Read more about \code{\link[=opt]{opt()}}.}

\item{std_out_err}{Logical. Whether to append a section for output sent to
stdout and stderr by the reprex rendering process. This can be necessary to
reveal output if the reprex spawns child processes or \code{system()} calls.
Note this cannot be properly interleaved with output from the main R
process, nor is there any guarantee that the lines from standard output and
standard error are in correct chronological order. See \code{\link[callr:r]{callr::r()}} for
more. Read more about \code{\link[=opt]{opt()}}.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
An R Markdown output format to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}.
}
\description{
This is an R Markdown output format designed specifically for making
"reprexes", typically created via the \code{\link[=reprex]{reprex()}} function, which ultimately
renders the document with \code{\link[=reprex_render]{reprex_render()}}. It is a heavily modified version
of \code{\link[rmarkdown:md_document]{rmarkdown::md_document()}}. The arguments have different spheres of
influence:
\itemize{
\item \code{venue} potentially affects input preparation and \code{\link[=reprex_render]{reprex_render()}}.
\item Add content to the primary input, prior to rendering:
\itemize{
\item \code{advertise}
\item \code{session_info}
\item \code{std_out_err} (also consulted by \code{\link[=reprex_render]{reprex_render()}})
}
\item Influence knitr package or chunk options:
\itemize{
\item \code{style}
\item \code{comment}
\item \code{tidyverse_quiet}
}
}

RStudio users can create new R Markdown documents with the
\code{reprex_document()} format using built-in templates. Do
\emph{File > New File > R Markdown ... > From Template} and choose one of:
\itemize{
\item reprex (minimal)
\item reprex (lots of features)
}

Both include \code{knit: reprex::reprex_render} in the YAML, which causes the
RStudio "Knit" button to use \code{reprex_render()}. If you render these documents
yourself, you should do same.
}
\examples{
reprex_document()
}
