% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{subsetIndex}
\alias{subsetIndex}
\alias{subsetIndex.default}
\alias{subsetIndex.matrix}
\title{Extract Specific Elements From An Object}
\usage{
subsetIndex(object, index, default, ...)

\method{subsetIndex}{default}(object, index, default, ...)

\method{subsetIndex}{matrix}(object, index, default, col = TRUE, ...)
}
\arguments{
\item{object}{A vector or a matrix.}

\item{index}{index of the elements to be extracted.
0 indicates that the column should be set to the default value.
NA indicates that the column should be set to NA.}

\item{default}{the default value.}

\item{...}{Only used by the generic method.}

\item{col}{If object is a matrix, \code{TRUE} lead to extract the columns and \code{FALSE} the rows.}
}
\description{
Extract specific elements from an object.
}
\examples{
M <- matrix(rnorm(50),5,10)
subsetIndex(M, index = c(0,0,1), default = 0)
subsetIndex(M, index = c(0,2,3,NA), default = 0)
subsetIndex(M, index = c(0,NA,2,3,NA), default = 0)

C <- 1:10
subsetIndex(C, index = c(0,0,1,5,NA), default = 0)
}
