% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-binding.R
\name{env_binding_lock}
\alias{env_binding_lock}
\alias{env_binding_unlock}
\alias{env_binding_are_locked}
\title{Lock or unlock environment bindings}
\usage{
env_binding_lock(env, nms = NULL)

env_binding_unlock(env, nms = NULL)

env_binding_are_locked(env, nms = NULL)
}
\arguments{
\item{env}{An environment.}

\item{nms}{Names of bindings. Defaults to all bindings in \code{env}.}
}
\value{
\code{env_binding_are_unlocked()} returns a logical vector as
long as \code{nms} and named after it. \code{env_binding_lock()} and
\code{env_binding_unlock()} return the old value of
\code{env_binding_are_unlocked()} invisibly.
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("experimental")}

Locked environment bindings trigger an error when an attempt is
made to redefine the binding.
}
\examples{
# Bindings are unlocked by default:
env <- env(a = "A", b = "B")
env_binding_are_locked(env)

# But can optionally be locked:
env_binding_lock(env, "a")
env_binding_are_locked(env)

# If run, the following would now return an error because `a` is locked:
# env_bind(env, a = "foo")
# with_env(env, a <- "bar")

# Let's unlock it. Note that the return value indicate which
# bindings were locked:
were_locked <- env_binding_unlock(env)
were_locked

# Now that it is unlocked we can modify it again:
env_bind(env, a = "foo")
with_env(env, a <- "bar")
env$a
}
\seealso{
\code{\link[=env_lock]{env_lock()}} for locking an environment.
}
\keyword{internal}
