% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-bytes.R
\name{label_bytes}
\alias{label_bytes}
\title{Label bytes (1 kb, 2 MB, etc)}
\usage{
label_bytes(units = "auto_si", accuracy = 1, ...)
}
\arguments{
\item{units}{Unit to use. Should either one of:
\itemize{
\item "kB", "MB", "GB", "TB", "PB", "EB", "ZB", and "YB" for
SI units (base 1000).
\item "kiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", and "YiB" for
binary units (base 1024).
\item \code{auto_si} or \code{auto_binary} to automatically pick the most approrpiate
unit for each value.
}}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{...}{Other arguments passed on to \code{\link[=number]{number()}}}
}
\value{
A labeller function that takes a numeric vector of breaks and
returns a character vector of labels.
}
\description{
Scale bytes into human friendly units. Can use either SI units (e.g.
kB = 1000 bytes) or binary units (e.g. kiB = 1024 bytes). See
\href{http://en.wikipedia.org/wiki/Units_of_information}{Units of Information}
on Wikipedia for more details.
}
\examples{
demo_continuous(c(1, 1e6))
demo_continuous(c(1, 1e6), label = label_bytes())
# Force all to use same units
demo_continuous(c(1, 1e6), label = label_bytes("kB"))

# Auto units are particularly nice on log scales
demo_log10(c(1, 1e6))
demo_log10(c(1, 1e7), label = label_bytes())

# You can also use binary units where a megabyte is defined as
# (1024) ^ 2 bytes rather than (1000) ^ 2. You'll need to override
# the default breaks to make this more informative.
demo_continuous(c(1, 1024^2), label = label_bytes("auto_binary"))
demo_continuous(c(1, 1024^2),
  breaks = breaks_width(250 * 1024),
  label = label_bytes("auto_binary")
)
}
\seealso{
Other labels for continuous scales: 
\code{\link{label_dollar}()},
\code{\link{label_number_auto}()},
\code{\link{label_number_si}()},
\code{\link{label_ordinal}()},
\code{\link{label_parse}()},
\code{\link{label_percent}()},
\code{\link{label_pvalue}()},
\code{\link{label_scientific}()}

Other labels for log scales: 
\code{\link{label_number_si}()},
\code{\link{label_scientific}()}
}
\concept{labels for continuous scales}
\concept{labels for log scales}
