% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measEq.R
\docType{class}
\name{measEq.syntax-class}
\alias{measEq.syntax-class}
\alias{show,measEq.syntax-method}
\alias{summary,measEq.syntax-method}
\alias{as.character,measEq.syntax-method}
\alias{update,measEq.syntax-method}
\title{Class for Representing a Measurement-Equivalence Model}
\usage{
\S4method{as.character}{measEq.syntax}(x, package = "lavaan")

\S4method{show}{measEq.syntax}(object)

\S4method{summary}{measEq.syntax}(object, verbose = TRUE)

\S4method{update}{measEq.syntax}(object, ..., evaluate = TRUE)
}
\arguments{
\item{x, object}{an object of class \code{measEq.syntax}}

\item{package}{\code{character} indicating the package for which the
syntax should be generated.  Currently, only \code{"lavaan"}.}

\item{verbose}{\code{logical} indicating whether to print a summary to the
screen (default). If \code{FALSE}, only a pattern matrix is returned.}

\item{...}{Additional arguments to the \code{call}, or arguments with
changed values.}

\item{evaluate}{If \code{TRUE}, evaluate the new \code{call}; otherwise,
return the new \code{call}.}
}
\value{
\item{summary}{\code{signature(object = "measEq.syntax", verbose = TRUE)}:
    A \code{character} matrix indicating the pattern of \code{numeric},
    \code{ordered}, or latent indicators loading on common factors.
    By default (\code{verbose = TRUE}), \code{summary} also prints descriptive
    details about the model, including the numbers of indicators and factors,
    and which parameters are constrained to equality.}
  \item{show}{\code{signature(object = "measEq.syntax")}: Prints a message
    about how to use the object for model fitting. Invisibly returns the
    object.}
  \item{update}{\code{signature(object = "measEq.syntax"), ...,
    evaluate = TRUE}: Creates a new object with updated arguments.}
  \item{as.character}{\code{signature(x = "measEq.syntax", package = "lavaan")}:
    Converts the \code{measEq.syntax} object to model syntax that can be
    copy/pasted into a syntax file to be edited before analysis, or simply
    passed to \code{\link[lavaan]{lavaan}} to fit the model to data.}
}
\description{
This class of object stores information used to automatically generate
lavaan model syntax to represent user-specified levels of measurement
equivalence/invariance across groups and/or repeated measures. See
\code{\link{measEq.syntax}} for details.
}
\section{Slots}{

\describe{
\item{\code{package}}{\code{character} indicating the software package used to
represent the model. Currently, only \code{"lavaan"} is available, which
uses the LISREL representation (see \code{\link[lavaan]{lavOptions}}).
In the future, \code{"OpenMx"} may become available, using RAM
representation.}

\item{\code{model.type}}{\code{character}. Currently, only "cfa" is available.
Future versions may allow for MIMIC / RFA models, where invariance can be
tested across levels of exogenous variables explicitly included as
predictors of indicators, controlling for their effects on (or correlation
with) the common factors.}

\item{\code{call}}{The function call as returned by \code{match.call()}, with
some arguments updated if necessary for logical consistency.}

\item{\code{meanstructure}}{\code{logical} indicating whether a mean structure is
included in the model.}

\item{\code{numeric}}{\code{character} vector naming \code{numeric} manifest indicators.}

\item{\code{ordered}}{\code{character} vector naming \code{ordered} indicators.}

\item{\code{parameterization}}{\code{character}. See \code{\link[lavaan]{lavOptions}}.}

\item{\code{specify}}{\code{list} of parameter matrices, similar in form to the
output of \code{\link[lavaan]{lavInspect}(fit, "free")}. These matrices
are \code{logical}, indicating whether each parameter should be specified
in the model syntax.}

\item{\code{values}}{\code{list} of parameter matrices, similar in form to the
output of \code{\link[lavaan]{lavInspect}(fit, "free")}. These matrices
are \code{numeric}, indicating whether each parameter should be freely
estimated (indicated by \code{NA}) or fixed to a particular value.}

\item{\code{labels}}{\code{list} of parameter matrices, similar in form to the
output of \code{\link[lavaan]{lavInspect}(fit, "free")}. These matrices
contain \code{character} labels used to constrain parameters to equality.}

\item{\code{constraints}}{\code{character} vector containing additional equality
constraints used to identify the model when \code{ID.fac = "fx"}.}

\item{\code{ngroups}}{\code{integer} indicating the number of groups.}
}}

\examples{
## See ?measEq.syntax help page

}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
