% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegionDefinitions.R
\name{IMGT_SCHEMES}
\alias{IMGT_SCHEMES}
\alias{IMGT_V}
\alias{IMGT_V_BY_CODONS}
\alias{IMGT_V_BY_REGIONS}
\alias{IMGT_V_BY_SEGMENTS}
\title{IMGT unique numbering schemes}
\format{
A \link{RegionDefinition} object defining:
\itemize{
  \item  \code{IMGT_V}:              The IMGT numbered V segment up to position nucleotide 312.
                                     This definition combines the CDR1 and CDR2 into a single CDR region,
                                     and FWR1, FWR2 and FWR3 into a single FWR region. CDR3 and FWR4 are
                                     excluded as they are downstream of nucleotide 312.
  \item  \code{IMGT_V_BY_CODONS}:    The IMGT numbered V segment up to position nucleotide 312.
                                     This definition treats each codon, from codon 1 to codon 104, as a 
                                     distinct region.
  \item  \code{IMGT_V_BY_REGIONS}:   The IMGT numbered V segment up to position nucleotide 312.
                                     This defines separate regions for each of CDR1, CDR2,
                                     FWR1, FWR2 and FWR3. CDR3 and FWR4 are
                                     excluded as they are downstream of nucleotide 312.
  \item  \code{IMGT_V_BY_SEGMENTS}:  The IMGT numbered V segment up to position nucleotide 312.
                                     This definition has no subdivisons and treats the entire V segment
                                     as a single region.
}
}
\description{
Sequence region definitions according to the IMGT unique numbering scheme.
}
\references{
\enumerate{
  \item  Lefranc MP, et al. IMGT unique numbering for immunoglobulin and T cell 
           receptor variable domains and Ig superfamily V-like domains. 
           Developmental and comparative immunology. 2003 27:55-77.
}
}
