% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{plotBaselineDensity}
\alias{plotBaselineDensity}
\title{Plots BASELINe probability density functions}
\usage{
plotBaselineDensity(
  baseline,
  idColumn,
  groupColumn = NULL,
  colorElement = c("id", "group"),
  colorValues = NULL,
  title = NULL,
  subsetRegions = NULL,
  sigmaLimits = c(-5, 5),
  facetBy = c("region", "group"),
  style = c("density"),
  sizeElement = c("none", "id", "group"),
  size = 1,
  silent = FALSE,
  ...
)
}
\arguments{
\item{baseline}{\code{Baseline} object containing selection probability 
density functions.}

\item{idColumn}{name of the column in the \code{db} slot of \code{baseline} 
containing primary identifiers.}

\item{groupColumn}{name of the column in the \code{db} slot of \code{baseline} 
containing secondary grouping identifiers. If \code{NULL}, 
organize the plot only on values in \code{idColumn}.}

\item{colorElement}{one of \code{c("id", "group")} specifying whether the 
\code{idColumn} or \code{groupColumn} will be used for color coding. 
The other entry, if present, will be coded by line style.}

\item{colorValues}{named vector of colors for entries in \code{colorElement}, with 
names defining unique values in the \code{colorElement} column and values
being colors. Also controls the order in which values appear on the
plot. If \code{NULL} alphabetical ordering and a default color palette 
will be used.}

\item{title}{string defining the plot title.}

\item{subsetRegions}{character vector defining a subset of regions to plot, correspoding 
to the regions for which the \code{baseline} data was calculated. If
\code{NULL} all regions in \code{baseline} are plotted.}

\item{sigmaLimits}{numeric vector containing two values defining the \code{c(lower, upper)}
bounds of the selection scores to plot.}

\item{facetBy}{one of \code{c("region", "group")} specifying which category to facet the
plot by, either values in \code{groupColumn} ("group") or regions
defined in the \code{regions} slot of the \code{baseline} object ("region").
If this is set to "group", then the region will behave as the \code{groupColumn}
for purposes of the \code{colorElement} argument.}

\item{style}{type of plot to draw. One of:
\itemize{
  \item \code{"density"}:  plots a set of curves for each probability 
                           density function in \code{baseline}, 
                           with colors determined by values in the
                           \code{colorElement} column.
                           Faceting is determined by the 
                           \code{facetBy} argument.
}}

\item{sizeElement}{one of \code{c("none", "id", "group")} specifying whether the lines in the
plot should be all of the same size (\code{none}) or have their sizes depend on 
the values in \code{id} or \code{code}.}

\item{size}{numeric scaling factor for lines, points and text in the plot.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A ggplot object defining the plot.
}
\description{
\code{plotBaselineDensity} plots the probability density functions resulting from selection 
analysis using the BASELINe method.
}
\examples{
\dontrun{
# Subset example data as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, c_call \%in\% c("IGHM", "IGHG"))
set.seed(112)
db <- dplyr::slice_sample(db, n=100)

# Collapse clones
db <- collapseClones(db, cloneColumn="clone_id",
                     sequenceColumn="sequence_alignment",
                     germlineColumn="germline_alignment_d_mask",
                     method="thresholdedFreq", minimumFrequency=0.6,
                     includeAmbiguous=FALSE, breakTiesStochastic=FALSE)
                     
# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="clonal_sequence",
                         germlineColumn="clonal_germline", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc=1)
 
# Grouping the PDFs by the sample and isotype annotations
grouped <- groupBaseline(baseline, groupBy=c("sample_id", "c_call"))

# Plot density faceted by region with custom isotype colors
isotype_colors <- c("IGHM"="darkorchid", "IGHD"="firebrick", 
                    "IGHG"="seagreen", "IGHA"="steelblue")
plotBaselineDensity(grouped, "sample_id", "c_call", colorValues=isotype_colors, 
                    colorElement="group", sigmaLimits=c(-1, 1))

# Facet by isotype instead of region
sample_colors <- c("-1h"="steelblue", "+7d"="firebrick")
plotBaselineDensity(grouped, "sample_id", "c_call", facetBy="group",
                    colorValues=sample_colors, sigmaLimits=c(-1, 1))
}

}
\seealso{
Takes as input a \link{Baseline} object returned from \link{groupBaseline}.
}
