% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterize.R
\name{st_rasterize}
\alias{st_rasterize}
\title{rasterize simple feature geometries}
\usage{
st_rasterize(
  sf,
  template = guess_raster(sf, ...) \%||\% st_as_stars(st_bbox(sf), values = NA_real_,
    ...),
  file = tempfile(),
  driver = "GTiff",
  options = character(0),
  align = FALSE,
  proxy = FALSE,
  ...
)
}
\arguments{
\item{sf}{object of class \code{sf}}

\item{template}{stars object with desired target geometry, or target geometry alignment if \code{align=TRUE}}

\item{file}{temporary file name}

\item{driver}{driver for temporary file}

\item{options}{character; options vector for \code{GDALRasterize}}

\item{align}{logical; if \code{TRUE}, \code{template} contain the geometry alignment, 
informing target resolution and offset only.}

\item{proxy}{logical; should a proxy object be returned?}

\item{...}{arguments passed on to \link{st_as_stars}}
}
\description{
rasterize simple feature geometries
}
\examples{
demo(nc, echo = FALSE, ask = FALSE)
(x = st_rasterize(nc)) # default grid:
plot(x, axes = TRUE)
# a bit more customized grid:
(x = st_rasterize(nc, st_as_stars(st_bbox(nc), nx = 100, ny = 50, values = NA_real_)))
plot(x, axes = TRUE)
(ls = st_sf(a = 1:2, st_sfc(st_linestring(rbind(c(0.1, 0), c(1.1, 1))),
   st_linestring(rbind(c(0, 0.05), c(1, 0.05))))))
(grd = st_as_stars(st_bbox(ls), nx = 10, ny = 10, xlim = c(0, 1.0), ylim = c(0, 1),
   values = NA_real_))
# Only the left-top corner is part of the grid cell:
sf_extSoftVersion()["GDAL"]
plot(st_rasterize(ls, grd), axes = TRUE, reset = FALSE) # ALL_TOUCHED=FALSE; 
plot(ls, add = TRUE, col = "red")
plot(st_rasterize(ls, grd, options = "ALL_TOUCHED=TRUE"), axes = TRUE, reset = FALSE)
plot(ls, add = TRUE, col = "red")
# add lines to existing 0 values, summing values in case of multiple lines:
(grd = st_as_stars(st_bbox(ls), nx = 10, ny = 10, xlim = c(0, 1.0), ylim = c(0, 1), values = 0))
r = st_rasterize(ls, grd, options = c("MERGE_ALG=ADD", "ALL_TOUCHED=TRUE"))
plot(r, axes = TRUE, reset = FALSE)
plot(ls, add = TRUE, col = "red")
}
