% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trimming method for statcheck output}
\usage{
trim(object, ...)
}
\arguments{
\item{object}{a \code{statcheck} object.}

\item{...}{additional arguments affecting the trimmed output.}
}
\value{
A data frame containing for each source of statistics:
\describe{
    \item{source}{Name of the file/origin of which the statistics are 
    extracted}
    \item{raw}{Raw string of the statistical reference that is extracted}
    \item{computed_p}{The recomputed p-value}
    \item{error}{The computed p value is not congruent with the reported 
    p-value}
    \item{decision_error}{The reported result is significant whereas the 
    recomputed result is not, or vice versa.}
}
}
\description{
Returns a subset of columns of a \code{statcheck} object.
}
\examples{
txt <- "blablabla the effect was very significant (t(100)=1, p < 0.001)"
stat <- statcheck(txt)
trim(stat)

}
