% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncbi_downstream.R
\name{ncbi_downstream}
\alias{ncbi_downstream}
\title{Retrieve all taxa names downstream in hierarchy for NCBI}
\usage{
ncbi_downstream(id, downto, intermediate = FALSE, ...)
}
\arguments{
\item{id}{(numeric/integer) An NCBI taxonomic identifier}

\item{downto}{The taxonomic level you want to go down to. See examples below.
The taxonomic level IS case sensitive, and you do have to spell it
correctly. See \code{data(rank_ref)} for spelling.}

\item{intermediate}{(logical) If \code{TRUE}, return a list of length two
with target taxon rank names, with additional list of data.frame's of
intermediate taxonomic groups. Default: \code{FALSE}}

\item{...}{Further args passed on to \code{\link[=ncbi_children]{ncbi_children()}}}
}
\value{
Data.frame of taxonomic information downstream to family from e.g.,
Order, Class, etc., or if \code{intermediate=TRUE}, list of length two,
with target taxon rank names, and intermediate names.
}
\description{
Retrieve all taxa names downstream in hierarchy for NCBI
}
\section{No Rank}{

A sticky point with NCBI is that they can have designation for taxonomic
rank of "No Rank". So we have no way of programatically knowing what to
do with that taxon. Of course one can manually look at a name and perhaps
know what it is, or look it up on the web - but we can't do anything
programatically. So, no rank things will sometimes be missing.
}

\section{Authentication}{

See \code{\link[=taxize-authentication]{taxize-authentication()}} for help on authentication.
We strongly recommend getting an API key
}

\examples{
\dontrun{
## genus Apis
ncbi_downstream(id = 7459, downto="species")

## get intermediate taxa as a separate object
ncbi_downstream(id = 7459, downto="species", intermediate = TRUE)

## Lepidoptera
ncbi_downstream(id = 7088, downto="superfamily")

## families in the ferns (Moniliformopses)
(id <- get_uid("Moniliformopses"))
ncbi_downstream(id = id, downto = "order")
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
