% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MACD.R
\name{MACD}
\alias{MACD}
\title{MACD Oscillator}
\usage{
MACD(x, nFast = 12, nSlow = 26, nSig = 9, maType, percent = TRUE, ...)
}
\arguments{
\item{x}{Object that is coercible to xts or matrix; usually price, but can be
volume, etc.}

\item{nFast}{Number of periods for fast moving average.}

\item{nSlow}{Number of periods for slow moving average.}

\item{nSig}{Number of periods for signal moving average.}

\item{maType}{Either:
\enumerate{
  \item A function or a string naming the function to be called.
  \item A \emph{list} with the first component like (1) above, and
    additional parameters specified as \emph{named} components.
    See Examples.
}}

\item{percent}{logical; if \code{TRUE}, the percentage difference between the
fast and slow moving averages is returned, otherwise the difference between
the respective averages is returned.}

\item{\dots}{Other arguments to be passed to the \code{maType} function in
case (1) above.}
}
\value{
A object of the same class as \code{x} or a matrix (if \code{try.xts}
fails) containing the columns:
\describe{
 \item{ macd }{ The price (volume, etc.) oscillator. }
 \item{ signal }{ The oscillator signal line (a moving average of the oscillator). }
}
}
\description{
The MACD was developed by Gerald Appel and is probably the most popular price
oscillator.  The MACD function documented in this page compares a fast moving
average (MA) of a series with a slow MA of the same series.  It can be used
as a generic oscillator for any univariate series, not only price.
}
\details{
The MACD function either subtracts the fast MA from the slow MA, or finds the
rate of change between the fast MA and the slow MA.
}
\note{
The MACD is a special case of the general oscillator applied to price.
The MACD can be used as a general oscillator applied to any series. Time
periods for the MACD are often given as 26 and 12, but the original formula
used exponential constants of 0.075 and 0.15, which are closer to
25.6667 and 12.3333 periods.
}
\examples{

data(ttrc)

macd  <- MACD( ttrc[,"Close"], 12, 26, 9, maType="EMA" )
macd2 <- MACD( ttrc[,"Close"], 12, 26, 9,
         maType=list(list(SMA), list(EMA, wilder=TRUE), list(SMA)) )

}
\references{
The following site(s) were used to code/document this
indicator:
\cr Moving Average Convergence/Divergence (MACD):\cr
\url{https://www.fmlabs.com/reference/MACD.htm}\cr
\url{https://www.metastock.com/Customer/Resources/TAAZ/?p=66}\cr
\url{https://www.linnsoft.com/techind/macd}\cr
\url{https://www.stockcharts.com/school/doku.php?id=chart_school:technical_indicators:moving_average_convergence_divergence_macd}\cr
\cr Price Oscillator:\cr
\url{https://www.fmlabs.com/reference/PriceOscillator.htm}\cr
\url{https://www.fmlabs.com/reference/PriceOscillatorPct.htm}\cr
\url{https://www.metastock.com/Customer/Resources/TAAZ/?p=94}\cr
\url{https://www.stockcharts.com/school/doku.php?id=chart_school:technical_indicators:price_oscillators_ppo}\cr
\cr Volume Oscillator:\cr
\url{https://www.fmlabs.com/reference/PVO.htm}\cr
\url{https://www.metastock.com/Customer/Resources/TAAZ/?p=122}\cr
}
\seealso{
See \code{\link{EMA}}, \code{\link{SMA}}, etc. for moving average
options; and note Warning section.
}
\author{
Joshua Ulrich
}
\keyword{ts}
