% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udunits.R
\name{ud_are_convertible}
\alias{ud_are_convertible}
\title{Test if two units are convertible}
\usage{
ud_are_convertible(x, y)
}
\arguments{
\item{x}{character or object of class \code{symbolic_units}, for the symbol
of the first unit.}

\item{y}{character or object of class \code{symbolic_units}, for the symbol
of the second unit.}
}
\value{
boolean, \code{TRUE} if both units exist and are convertible.
}
\description{
Parses and checks whether units can be converted by UDUNITS-2. Units may not
be convertible either because they are different magnitudes or because one
(or both) units are not defined in the database.
}
\examples{
ud_are_convertible("m", "km")
a <- set_units(1:3, m/s)
ud_are_convertible(units(a), "km/h")
ud_are_convertible("s", "kg")
}
