% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_sid}
\alias{as_sid}
\title{Convert an input to a source property SID}
\usage{
as_sid(x)
}
\arguments{
\item{x}{a vector, data frame, or tibble of strings representaing wikidata source properties}
}
\value{
if the inputted string is a valid SID, return the string.
If the inputted string matches a property label, return its SID
If the inputted string matches multiple labels of multiple properties, return the SID of the first hit.
}
\description{
Convert an input string to the most likely source SID (equivalent to PID)
}
\examples{
# if input string is a valid SID
as_pid("S854")
# if input string matches multiple item labels
as_pid("URL")
# if input string matches a single unique label
as_pid("Reference URL")
}
